/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.ml.feature.lsh;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Random;
import org.apache.flink.api.common.serialization.Encoder;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.base.IntSerializer;
import org.apache.flink.api.common.typeutils.base.array.IntPrimitiveArraySerializer;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.connector.file.src.reader.SimpleStreamFormat;
import org.apache.flink.connector.file.src.reader.StreamFormat;
import org.apache.flink.core.fs.FSDataInputStream;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataInputViewStreamWrapper;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.core.memory.DataOutputViewStreamWrapper;
import org.apache.flink.ml.feature.lsh.LSHModelData;
import org.apache.flink.ml.linalg.DenseVector;
import org.apache.flink.ml.linalg.Vector;
import org.apache.flink.util.Preconditions;

public class MinHashLSHModelData
extends LSHModelData {
    private static final int HASH_PRIME = 2038074743;
    public int numHashTables;
    public int numHashFunctionsPerTable;
    public int[] randCoefficientA;
    public int[] randCoefficientB;

    public MinHashLSHModelData() {
    }

    public MinHashLSHModelData(int numHashTables, int numHashFunctionsPerTable, int[] randCoefficientA, int[] randCoefficientB) {
        this.numHashTables = numHashTables;
        this.numHashFunctionsPerTable = numHashFunctionsPerTable;
        this.randCoefficientA = randCoefficientA;
        this.randCoefficientB = randCoefficientB;
    }

    public static MinHashLSHModelData generateModelData(int numHashTables, int numHashFunctionsPerTable, int dim, long seed) {
        Preconditions.checkArgument((dim <= 2038074743 ? 1 : 0) != 0, (String)"The input vector dimension %d exceeds the threshold %s.", (Object[])new Object[]{dim, 2038074743});
        Random random = new Random(seed);
        int numHashFunctions = numHashTables * numHashFunctionsPerTable;
        int[] randCoeffA = new int[numHashFunctions];
        int[] randCoeffB = new int[numHashFunctions];
        for (int i = 0; i < numHashFunctions; ++i) {
            randCoeffA[i] = 1 + random.nextInt(2038074742);
            randCoeffB[i] = random.nextInt(2038074742);
        }
        return new MinHashLSHModelData(numHashTables, numHashFunctionsPerTable, randCoeffA, randCoeffB);
    }

    @Override
    public DenseVector[] hashFunction(Vector vec) {
        int[] indices = vec.toSparse().indices;
        Preconditions.checkArgument((indices.length > 0 ? 1 : 0) != 0, (Object)"Must have at least 1 non zero entry.");
        double[][] hashValues = new double[this.numHashTables][this.numHashFunctionsPerTable];
        for (int i = 0; i < this.numHashTables; ++i) {
            for (int j = 0; j < this.numHashFunctionsPerTable; ++j) {
                int coeffA = this.randCoefficientA[i * this.numHashFunctionsPerTable + j];
                int coeffB = this.randCoefficientB[i * this.numHashFunctionsPerTable + j];
                long minv = 2038074743L;
                for (int index : indices) {
                    minv = Math.min(minv, ((1L + (long)index) * (long)coeffA + (long)coeffB) % 2038074743L);
                }
                hashValues[i][j] = minv;
            }
        }
        return (DenseVector[])Arrays.stream(hashValues).map(DenseVector::new).toArray(DenseVector[]::new);
    }

    @Override
    public double keyDistance(Vector x, Vector y) {
        int[] xIndices = x.toSparse().indices;
        int[] yIndices = y.toSparse().indices;
        Preconditions.checkArgument((xIndices.length + yIndices.length > 0 ? 1 : 0) != 0, (Object)"The union of two input sets must have at least 1 elements");
        int px = 0;
        int py = 0;
        int intersectionSize = 0;
        while (px < xIndices.length && py < yIndices.length) {
            if (xIndices[px] == yIndices[py]) {
                ++intersectionSize;
                ++px;
                ++py;
                continue;
            }
            if (xIndices[px] < yIndices[py]) {
                ++px;
                continue;
            }
            ++py;
        }
        int unionSize = xIndices.length + yIndices.length - intersectionSize;
        return 1.0 - 1.0 * (double)intersectionSize / (double)unionSize;
    }

    public static class ModelDataEncoder
    implements Encoder<MinHashLSHModelData> {
        public void encode(MinHashLSHModelData modelData, OutputStream outputStream) throws IOException {
            DataOutputViewStreamWrapper dataOutputView = new DataOutputViewStreamWrapper(outputStream);
            IntSerializer.INSTANCE.serialize(Integer.valueOf(modelData.numHashTables), (DataOutputView)dataOutputView);
            IntSerializer.INSTANCE.serialize(Integer.valueOf(modelData.numHashFunctionsPerTable), (DataOutputView)dataOutputView);
            IntPrimitiveArraySerializer.INSTANCE.serialize(modelData.randCoefficientA, (DataOutputView)dataOutputView);
            IntPrimitiveArraySerializer.INSTANCE.serialize(modelData.randCoefficientB, (DataOutputView)dataOutputView);
        }
    }

    static class ModelDataDecoder
    extends SimpleStreamFormat<MinHashLSHModelData> {
        ModelDataDecoder() {
        }

        public StreamFormat.Reader<MinHashLSHModelData> createReader(Configuration configuration, final FSDataInputStream fsDataInputStream) throws IOException {
            return new StreamFormat.Reader<MinHashLSHModelData>(){

                public MinHashLSHModelData read() throws IOException {
                    try {
                        DataInputViewStreamWrapper source = new DataInputViewStreamWrapper((InputStream)fsDataInputStream);
                        int numHashTables = IntSerializer.INSTANCE.deserialize((DataInputView)source);
                        int numHashFunctionsPerTable = IntSerializer.INSTANCE.deserialize((DataInputView)source);
                        int[] randCoeffA = IntPrimitiveArraySerializer.INSTANCE.deserialize((DataInputView)source);
                        int[] randCoeffB = IntPrimitiveArraySerializer.INSTANCE.deserialize((DataInputView)source);
                        return new MinHashLSHModelData(numHashTables, numHashFunctionsPerTable, randCoeffA, randCoeffB);
                    }
                    catch (EOFException e) {
                        return null;
                    }
                }

                public void close() throws IOException {
                    fsDataInputStream.close();
                }
            };
        }

        public TypeInformation<MinHashLSHModelData> getProducedType() {
            return TypeInformation.of(MinHashLSHModelData.class);
        }
    }
}

