/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.ml.feature.regextokenizer;

import org.apache.flink.ml.common.param.HasInputCol;
import org.apache.flink.ml.common.param.HasOutputCol;
import org.apache.flink.ml.param.BooleanParam;
import org.apache.flink.ml.param.IntParam;
import org.apache.flink.ml.param.ParamValidators;
import org.apache.flink.ml.param.StringParam;

public interface RegexTokenizerParams<T>
extends HasInputCol<T>,
HasOutputCol<T> {
    public static final IntParam MIN_TOKEN_LENGTH = new IntParam("minTokenLength", "Minimum token length", 1, ParamValidators.gtEq(0.0));
    public static final BooleanParam GAPS = new BooleanParam("gaps", "Set regex to match gaps or tokens", true);
    public static final StringParam PATTERN = new StringParam("pattern", "Regex pattern used for tokenizing", "\\s+");
    public static final BooleanParam TO_LOWERCASE = new BooleanParam("toLowercase", "Whether to convert all characters to lowercase before tokenizing", true);

    default public T setMinTokenLength(int value) {
        return this.set(MIN_TOKEN_LENGTH, value);
    }

    default public int getMinTokenLength() {
        return this.get(MIN_TOKEN_LENGTH);
    }

    default public T setGaps(boolean value) {
        return this.set(GAPS, value);
    }

    default public Boolean getGaps() {
        return this.get(GAPS);
    }

    default public T setPattern(String pattern) {
        return this.set(PATTERN, pattern);
    }

    default public String getPattern() {
        return this.get(PATTERN);
    }

    default public T setToLowercase(boolean toLowercase) {
        return this.set(TO_LOWERCASE, toLowercase);
    }

    default public Boolean getToLowercase() {
        return this.get(TO_LOWERCASE);
    }
}

