/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.ml.feature.standardscaler;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.flink.api.common.state.ListState;
import org.apache.flink.api.common.state.ListStateDescriptor;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeinfo.Types;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.typeutils.RowTypeInfo;
import org.apache.flink.iteration.operator.OperatorStateUtils;
import org.apache.flink.metrics.MetricGroup;
import org.apache.flink.ml.api.Model;
import org.apache.flink.ml.common.datastream.TableUtils;
import org.apache.flink.ml.feature.standardscaler.OnlineStandardScalerModelParams;
import org.apache.flink.ml.feature.standardscaler.StandardScalerModelData;
import org.apache.flink.ml.linalg.BLAS;
import org.apache.flink.ml.linalg.DenseVector;
import org.apache.flink.ml.linalg.Vector;
import org.apache.flink.ml.linalg.typeinfo.VectorTypeInfo;
import org.apache.flink.ml.param.Param;
import org.apache.flink.ml.util.ParamUtils;
import org.apache.flink.ml.util.ReadWriteUtils;
import org.apache.flink.runtime.state.StateInitializationContext;
import org.apache.flink.runtime.state.StateSnapshotContext;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.datastream.SingleOutputStreamOperator;
import org.apache.flink.streaming.api.operators.AbstractStreamOperator;
import org.apache.flink.streaming.api.operators.TwoInputStreamOperator;
import org.apache.flink.streaming.runtime.streamrecord.StreamElementSerializer;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.bridge.java.StreamTableEnvironment;
import org.apache.flink.table.api.internal.TableImpl;
import org.apache.flink.types.Row;
import org.apache.flink.util.Preconditions;

public class OnlineStandardScalerModel
implements Model<OnlineStandardScalerModel>,
OnlineStandardScalerModelParams<OnlineStandardScalerModel> {
    private final Map<Param<?>, Object> paramMap = new HashMap();
    private Table modelDataTable;

    public OnlineStandardScalerModel() {
        ParamUtils.initializeMapWithDefaultValues(this.paramMap, this);
    }

    @Override
    public Table[] transform(Table ... inputs) {
        String[] outputNames;
        TypeInformation[] outputTypes;
        Preconditions.checkArgument((inputs.length == 1 ? 1 : 0) != 0);
        StreamTableEnvironment tEnv = (StreamTableEnvironment)((TableImpl)inputs[0]).getTableEnvironment();
        RowTypeInfo inputTypeInfo = TableUtils.getRowTypeInfo(inputs[0].getResolvedSchema());
        String modelVersionCol = this.getModelVersionCol();
        if (modelVersionCol == null) {
            outputTypes = (TypeInformation[])ArrayUtils.addAll((Object[])inputTypeInfo.getFieldTypes(), (Object[])new TypeInformation[]{VectorTypeInfo.INSTANCE});
            outputNames = (String[])ArrayUtils.addAll((Object[])inputTypeInfo.getFieldNames(), (Object[])new String[]{this.getOutputCol()});
        } else {
            outputTypes = (TypeInformation[])ArrayUtils.addAll((Object[])inputTypeInfo.getFieldTypes(), (Object[])new TypeInformation[]{VectorTypeInfo.INSTANCE, Types.LONG});
            outputNames = (String[])ArrayUtils.addAll((Object[])inputTypeInfo.getFieldNames(), (Object[])new String[]{this.getOutputCol(), modelVersionCol});
        }
        RowTypeInfo outputTypeInfo = new RowTypeInfo(outputTypes, outputNames);
        SingleOutputStreamOperator predictionResult = tEnv.toDataStream(inputs[0]).connect(StandardScalerModelData.getModelDataStream(this.modelDataTable).broadcast()).transform("PredictionOperator", (TypeInformation)outputTypeInfo, (TwoInputStreamOperator)new PredictionOperator(inputTypeInfo, this.getInputCol(), this.getWithMean(), this.getWithStd(), this.getMaxAllowedModelDelayMs(), this.getModelVersionCol()));
        return new Table[]{tEnv.fromDataStream((DataStream)predictionResult)};
    }

    @Override
    public void save(String path) throws IOException {
        ReadWriteUtils.saveMetadata(this, path);
    }

    public static OnlineStandardScalerModel load(StreamTableEnvironment tEnv, String path) throws IOException {
        return (OnlineStandardScalerModel)ReadWriteUtils.loadStageParam(path);
    }

    @Override
    public Map<Param<?>, Object> getParamMap() {
        return this.paramMap;
    }

    @Override
    public OnlineStandardScalerModel setModelData(Table ... inputs) {
        Preconditions.checkArgument((inputs.length == 1 ? 1 : 0) != 0);
        this.modelDataTable = inputs[0];
        return this;
    }

    @Override
    public Table[] getModelData() {
        return new Table[]{this.modelDataTable};
    }

    private static class PredictionOperator
    extends AbstractStreamOperator<Row>
    implements TwoInputStreamOperator<Row, StandardScalerModelData, Row> {
        private final RowTypeInfo inputTypeInfo;
        private final String inputCol;
        private final boolean withMean;
        private final boolean withStd;
        private final long maxAllowedModelDelayMs;
        private final String modelVersionCol;
        private ListState<StreamRecord> bufferedPointsState;
        private ListState<StandardScalerModelData> modelDataState;
        private StandardScalerModelData modelData;
        private DenseVector mean;
        private DenseVector scale;
        private long modelVersion;
        private long modelTimeStamp;

        public PredictionOperator(RowTypeInfo inputTypeInfo, String inputCol, boolean withMean, boolean withStd, long maxAllowedModelDelayMs, String modelVersionCol) {
            this.inputTypeInfo = inputTypeInfo;
            this.inputCol = inputCol;
            this.withMean = withMean;
            this.withStd = withStd;
            this.maxAllowedModelDelayMs = maxAllowedModelDelayMs;
            this.modelVersionCol = modelVersionCol;
        }

        public void initializeState(StateInitializationContext context) throws Exception {
            super.initializeState(context);
            this.bufferedPointsState = context.getOperatorStateStore().getListState(new ListStateDescriptor("bufferedPoints", (TypeSerializer)new StreamElementSerializer(this.inputTypeInfo.createSerializer(this.getExecutionConfig()))));
            this.modelDataState = context.getOperatorStateStore().getListState(new ListStateDescriptor("modelData", TypeInformation.of(StandardScalerModelData.class)));
            this.modelData = OperatorStateUtils.getUniqueElement(this.modelDataState, "modelData").orElse(null);
            if (this.modelData != null) {
                this.initializeModelData(this.modelData);
            } else {
                this.modelTimeStamp = -1L;
                this.modelVersion = -1L;
            }
        }

        public void snapshotState(StateSnapshotContext context) throws Exception {
            super.snapshotState(context);
            if (this.modelData != null) {
                this.modelDataState.clear();
                this.modelDataState.add((Object)this.modelData);
            }
        }

        public void open() throws Exception {
            super.open();
            MetricGroup mlModelMetricGroup = this.getRuntimeContext().getMetricGroup().addGroup("ml").addGroup("model", OnlineStandardScalerModel.class.getSimpleName());
            mlModelMetricGroup.gauge("timestamp", () -> this.modelTimeStamp);
            mlModelMetricGroup.gauge("version", () -> this.modelVersion);
        }

        public void processElement1(StreamRecord<Row> dataPoint) throws Exception {
            if (dataPoint.getTimestamp() - this.maxAllowedModelDelayMs <= this.modelTimeStamp && this.mean != null) {
                this.doPrediction(dataPoint);
            } else {
                this.bufferedPointsState.add(dataPoint);
            }
        }

        public void processElement2(StreamRecord<StandardScalerModelData> streamRecord) throws Exception {
            this.modelData = (StandardScalerModelData)streamRecord.getValue();
            this.initializeModelData(this.modelData);
            ArrayList<StreamRecord> unprocessedElements = new ArrayList<StreamRecord>();
            boolean predictedCachedData = false;
            for (StreamRecord dataPoint : (Iterable)this.bufferedPointsState.get()) {
                if (dataPoint.getTimestamp() - this.maxAllowedModelDelayMs <= this.modelTimeStamp) {
                    this.doPrediction((StreamRecord<Row>)dataPoint);
                    predictedCachedData = true;
                    continue;
                }
                unprocessedElements.add(dataPoint);
            }
            if (predictedCachedData) {
                this.bufferedPointsState.clear();
                if (unprocessedElements.size() > 0) {
                    this.bufferedPointsState.update(unprocessedElements);
                }
            }
        }

        private void initializeModelData(StandardScalerModelData modelData) {
            this.modelTimeStamp = modelData.timestamp;
            this.modelVersion = modelData.version;
            this.mean = modelData.mean;
            DenseVector std = modelData.std;
            if (this.withStd) {
                this.scale = std;
                double[] scaleValues = this.scale.values;
                for (int i = 0; i < scaleValues.length; ++i) {
                    scaleValues[i] = scaleValues[i] == 0.0 ? 0.0 : 1.0 / scaleValues[i];
                }
            }
        }

        private void doPrediction(StreamRecord<Row> streamRecord) {
            Row dataPoint = (Row)streamRecord.getValue();
            Vector outputVec = ((Vector)Objects.requireNonNull(dataPoint.getField(this.inputCol))).clone();
            if (this.withMean) {
                outputVec = outputVec.toDense();
                BLAS.axpy(-1.0, this.mean, (DenseVector)outputVec);
            }
            if (this.withStd) {
                BLAS.hDot((Vector)this.scale, outputVec);
            }
            if (this.modelVersionCol == null) {
                this.output.collect((Object)new StreamRecord((Object)Row.join((Row)dataPoint, (Row[])new Row[]{Row.of((Object[])new Object[]{outputVec})}), streamRecord.getTimestamp()));
            } else {
                this.output.collect((Object)new StreamRecord((Object)Row.join((Row)dataPoint, (Row[])new Row[]{Row.of((Object[])new Object[]{outputVec, this.modelVersion})}), streamRecord.getTimestamp()));
            }
        }
    }
}

