/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.ml.feature.stopwordsremover;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import org.apache.flink.ml.feature.stopwordsremover.StopWordsRemover;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class StopWordsRemoverUtils {
    private static final Set<String> SUPPORTED_LANGUAGES = new HashSet<String>(Arrays.asList("danish", "dutch", "english", "finnish", "french", "german", "hungarian", "italian", "norwegian", "portuguese", "russian", "spanish", "swedish", "turkish"));
    private static final Logger LOG = LoggerFactory.getLogger(StopWordsRemover.class);

    StopWordsRemoverUtils() {
    }

    static String[] loadDefaultStopWords(String language) {
        Preconditions.checkArgument((boolean)SUPPORTED_LANGUAGES.contains(language), (String)"%s is not in the supported language list: %s.", (Object[])new Object[]{language, SUPPORTED_LANGUAGES});
        InputStream in = StopWordsRemover.class.getClassLoader().getResourceAsStream("org/apache/flink/ml/feature/stopwords/" + language + ".txt");
        return (String[])new BufferedReader(new InputStreamReader(in, StandardCharsets.UTF_8)).lines().toArray(String[]::new);
    }

    static String getDefaultOrUS() {
        if (Arrays.asList(Locale.getAvailableLocales()).contains(Locale.getDefault())) {
            return Locale.getDefault().toString();
        }
        LOG.warn("Default locale set was [{}]; however, it was not found in available locales in JVM, falling back to en_US locale. Set param `locale` in order to respect another locale.", (Object)Locale.getDefault());
        return Locale.US.toString();
    }

    static Set<String> getAvailableLocales() {
        HashSet<String> locales = new HashSet<String>();
        for (Locale locale : Locale.getAvailableLocales()) {
            locales.add(locale.toString());
        }
        return locales;
    }
}

