/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.ml.feature.univariatefeatureselector;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import org.apache.flink.api.common.functions.MapFunction;
import org.apache.flink.api.common.serialization.Encoder;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.base.array.IntPrimitiveArraySerializer;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.connector.file.src.reader.SimpleStreamFormat;
import org.apache.flink.connector.file.src.reader.StreamFormat;
import org.apache.flink.core.fs.FSDataInputStream;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataInputViewStreamWrapper;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.core.memory.DataOutputViewStreamWrapper;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.bridge.java.StreamTableEnvironment;
import org.apache.flink.table.api.internal.TableImpl;

public class UnivariateFeatureSelectorModelData {
    public int[] indices;

    public UnivariateFeatureSelectorModelData() {
    }

    public UnivariateFeatureSelectorModelData(int[] indices) {
        this.indices = indices;
    }

    public static DataStream<UnivariateFeatureSelectorModelData> getModelDataStream(Table modelDataTable) {
        StreamTableEnvironment tEnv = (StreamTableEnvironment)((TableImpl)modelDataTable).getTableEnvironment();
        return tEnv.toDataStream(modelDataTable).map((MapFunction & Serializable)x -> new UnivariateFeatureSelectorModelData((int[])x.getField(0)));
    }

    public static class ModelDataDecoder
    extends SimpleStreamFormat<UnivariateFeatureSelectorModelData> {
        public StreamFormat.Reader<UnivariateFeatureSelectorModelData> createReader(Configuration config, final FSDataInputStream stream) {
            return new StreamFormat.Reader<UnivariateFeatureSelectorModelData>(){

                public UnivariateFeatureSelectorModelData read() throws IOException {
                    DataInputViewStreamWrapper source = new DataInputViewStreamWrapper((InputStream)stream);
                    try {
                        int[] indices = IntPrimitiveArraySerializer.INSTANCE.deserialize((DataInputView)source);
                        return new UnivariateFeatureSelectorModelData(indices);
                    }
                    catch (EOFException e) {
                        return null;
                    }
                }

                public void close() throws IOException {
                    stream.close();
                }
            };
        }

        public TypeInformation<UnivariateFeatureSelectorModelData> getProducedType() {
            return TypeInformation.of(UnivariateFeatureSelectorModelData.class);
        }
    }

    public static class ModelDataEncoder
    implements Encoder<UnivariateFeatureSelectorModelData> {
        public void encode(UnivariateFeatureSelectorModelData modelData, OutputStream outputStream) throws IOException {
            DataOutputViewStreamWrapper dataOutputView = new DataOutputViewStreamWrapper(outputStream);
            IntPrimitiveArraySerializer.INSTANCE.serialize(modelData.indices, (DataOutputView)dataOutputView);
        }
    }
}

