/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.ml.linalg.typeinfo;

import java.io.IOException;
import org.apache.flink.api.common.typeutils.SimpleTypeSerializerSnapshot;
import org.apache.flink.api.common.typeutils.TypeSerializerSnapshot;
import org.apache.flink.api.common.typeutils.base.TypeSerializerSingleton;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.ml.linalg.DenseVector;
import org.apache.flink.ml.linalg.SparseVector;
import org.apache.flink.ml.linalg.Vector;
import org.apache.flink.ml.linalg.typeinfo.DenseVectorSerializer;
import org.apache.flink.ml.linalg.typeinfo.SparseVectorSerializer;

public final class VectorSerializer
extends TypeSerializerSingleton<Vector> {
    private static final long serialVersionUID = 1L;
    private static final double[] EMPTY = new double[0];
    private final DenseVectorSerializer denseVectorSerializer = new DenseVectorSerializer();
    private static final SparseVectorSerializer SPARSE_VECTOR_SERIALIZER = SparseVectorSerializer.INSTANCE;

    public boolean isImmutableType() {
        return false;
    }

    public Vector createInstance() {
        return new DenseVector(EMPTY);
    }

    public Vector copy(Vector from) {
        if (from instanceof DenseVector) {
            return this.denseVectorSerializer.copy((DenseVector)from);
        }
        return SPARSE_VECTOR_SERIALIZER.copy((SparseVector)from);
    }

    public Vector copy(Vector from, Vector reuse) {
        assert (from.getClass() == reuse.getClass());
        if (from instanceof DenseVector) {
            return this.denseVectorSerializer.copy((DenseVector)from, (DenseVector)reuse);
        }
        return SPARSE_VECTOR_SERIALIZER.copy((SparseVector)from, (SparseVector)reuse);
    }

    public int getLength() {
        return -1;
    }

    public void serialize(Vector vector, DataOutputView target) throws IOException {
        if (vector instanceof DenseVector) {
            target.writeByte(0);
            this.denseVectorSerializer.serialize((DenseVector)vector, target);
        } else {
            target.writeByte(1);
            SPARSE_VECTOR_SERIALIZER.serialize((SparseVector)vector, target);
        }
    }

    public Vector deserialize(DataInputView source) throws IOException {
        byte type = source.readByte();
        if (type == 0) {
            return this.denseVectorSerializer.deserialize(source);
        }
        return SPARSE_VECTOR_SERIALIZER.deserialize(source);
    }

    public Vector deserialize(Vector reuse, DataInputView source) throws IOException {
        byte type = source.readByte();
        assert (type == 0 && reuse instanceof DenseVector || type == 1 && reuse instanceof SparseVector);
        if (type == 0) {
            return this.denseVectorSerializer.deserialize(source);
        }
        return SPARSE_VECTOR_SERIALIZER.deserialize(source);
    }

    public void copy(DataInputView source, DataOutputView target) throws IOException {
        this.serialize(this.deserialize(source), target);
    }

    public TypeSerializerSnapshot<Vector> snapshotConfiguration() {
        return new VectorSerializerSnapshot();
    }

    public static final class VectorSerializerSnapshot
    extends SimpleTypeSerializerSnapshot<Vector> {
        public VectorSerializerSnapshot() {
            super(VectorSerializer::new);
        }
    }
}

