/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.ml.servable.api;

import java.util.Iterator;
import java.util.List;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.ml.servable.api.Row;
import org.apache.flink.ml.servable.types.DataType;

@PublicEvolving
public class DataFrame {
    private final List<String> columnNames;
    private final List<DataType> dataTypes;
    private final List<Row> rows;

    public DataFrame(List<String> columnNames, List<DataType> dataTypes, List<Row> rows) {
        int numColumns = columnNames.size();
        if (dataTypes.size() != numColumns) {
            throw new IllegalArgumentException(String.format("The number of data types %d is different from the number of column names %d.", dataTypes.size(), numColumns));
        }
        for (Row row : rows) {
            if (row.size() == numColumns) continue;
            throw new IllegalArgumentException(String.format("The row size %d is different from the number of column names %d.", row.size(), numColumns));
        }
        this.columnNames = columnNames;
        this.dataTypes = dataTypes;
        this.rows = rows;
    }

    public List<String> getColumnNames() {
        return this.columnNames;
    }

    public int getIndex(String name) {
        int index = this.columnNames.indexOf(name);
        if (index == -1) {
            throw new IllegalArgumentException(String.format("Failed to find the column with the name %s.", name));
        }
        return index;
    }

    public DataType getDataType(String name) {
        int index = this.getIndex(name);
        return this.dataTypes.get(index);
    }

    public DataFrame addColumn(String columnName, DataType dataType, List<?> values) {
        if (values.size() != this.rows.size()) {
            throw new RuntimeException(String.format("The number of values %d is different from the number of rows %d.", values.size(), this.rows.size()));
        }
        this.columnNames.add(columnName);
        this.dataTypes.add(dataType);
        Iterator<?> iter = values.iterator();
        for (Row row : this.rows) {
            Object value = iter.next();
            row.add(value);
        }
        return this;
    }

    public List<Row> collect() {
        return this.rows;
    }
}

