/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.ml.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Map;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.core.fs.Path;
import org.apache.flink.ml.util.JsonUtils;

public class FileUtils {
    public static void saveToFile(String pathStr, String content, boolean isOverwrite) throws IOException {
        Path path = new Path(pathStr);
        FileSystem fs = FileUtils.mkdirs(path.getParent());
        FileSystem.WriteMode writeMode = FileSystem.WriteMode.OVERWRITE;
        if (!isOverwrite) {
            writeMode = FileSystem.WriteMode.NO_OVERWRITE;
            if (fs.exists(path)) {
                throw new IOException("File " + path + " already exists.");
            }
        }
        try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)fs.create(path, writeMode)));){
            writer.write(content);
        }
    }

    public static FileSystem mkdirs(Path path) throws IOException {
        FileSystem fs = path.getFileSystem();
        fs.mkdirs(path);
        return fs;
    }

    public static Map<String, ?> loadMetadata(String path, String expectedClassName) throws IOException {
        Path metadataPath = new Path(path, "metadata");
        FileSystem fs = metadataPath.getFileSystem();
        StringBuilder buffer = new StringBuilder();
        try (BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)fs.open(metadataPath)));){
            String line;
            while ((line = br.readLine()) != null) {
                if (line.startsWith("#")) continue;
                buffer.append(line);
            }
        }
        Map result = (Map)JsonUtils.OBJECT_MAPPER.readValue(buffer.toString(), Map.class);
        String className = (String)result.get("className");
        if (!expectedClassName.isEmpty() && !expectedClassName.equals(className)) {
            throw new RuntimeException("Class name " + className + " does not match the expected class name " + expectedClassName + ".");
        }
        return result;
    }

    public static String getPathForPipelineStage(int stageIdx, int numStages, String parentPath) {
        String format = String.format("stages%s%%0%dd", File.separator, String.valueOf(numStages).length());
        String fileName = String.format(format, stageIdx);
        return new Path(parentPath, fileName).toString();
    }

    public static Path getDataPath(String path) {
        return new Path(path, "data");
    }
}

