/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.ml.util;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.flink.api.common.eventtime.WatermarkStrategy;
import org.apache.flink.api.common.serialization.Encoder;
import org.apache.flink.api.connector.sink2.Sink;
import org.apache.flink.api.connector.source.Source;
import org.apache.flink.connector.file.sink.FileSink;
import org.apache.flink.connector.file.src.FileSource;
import org.apache.flink.connector.file.src.reader.SimpleStreamFormat;
import org.apache.flink.core.fs.Path;
import org.apache.flink.ml.api.Stage;
import org.apache.flink.ml.builder.Graph;
import org.apache.flink.ml.builder.GraphData;
import org.apache.flink.ml.builder.GraphModel;
import org.apache.flink.ml.builder.GraphNode;
import org.apache.flink.ml.common.datastream.TableUtils;
import org.apache.flink.ml.param.Param;
import org.apache.flink.ml.util.FileUtils;
import org.apache.flink.ml.util.ParamUtils;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.JsonParser;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.datastream.DataStreamSource;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.streaming.api.functions.sink.filesystem.BucketAssigner;
import org.apache.flink.streaming.api.functions.sink.filesystem.RollingPolicy;
import org.apache.flink.streaming.api.functions.sink.filesystem.bucketassigners.BasePathBucketAssigner;
import org.apache.flink.streaming.api.functions.sink.filesystem.rollingpolicies.OnCheckpointRollingPolicy;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.bridge.java.StreamTableEnvironment;
import org.apache.flink.util.Preconditions;

public class ReadWriteUtils {
    public static final ObjectMapper OBJECT_MAPPER = new ObjectMapper().enable(new JsonParser.Feature[]{JsonParser.Feature.ALLOW_COMMENTS});

    private static <T> Object jsonEncodeHelper(Param<T> param, Object value) throws IOException {
        return param.jsonEncode(value);
    }

    private static Map<String, Object> jsonEncode(Map<Param<?>, Object> paramMap) throws IOException {
        HashMap<String, Object> result = new HashMap<String, Object>(paramMap.size());
        for (Map.Entry<Param<?>, Object> entry : paramMap.entrySet()) {
            Object json = ReadWriteUtils.jsonEncodeHelper(entry.getKey(), entry.getValue());
            result.put(entry.getKey().name, json);
        }
        return result;
    }

    public static void saveMetadata(Stage<?> stage, String path, Map<String, ?> extraMetadata) throws IOException {
        HashMap metadata = new HashMap(extraMetadata);
        metadata.put("className", stage.getClass().getName());
        metadata.put("timestamp", System.currentTimeMillis());
        metadata.put("paramMap", ReadWriteUtils.jsonEncode(stage.getParamMap()));
        String metadataStr = OBJECT_MAPPER.writeValueAsString(metadata);
        FileUtils.saveToFile(new Path(path, "metadata").toUri().toString(), metadataStr, false);
    }

    public static void saveMetadata(Stage<?> stage, String path) throws IOException {
        ReadWriteUtils.saveMetadata(stage, path, new HashMap());
    }

    public static void savePipeline(Stage<?> pipeline, List<Stage<?>> stages, String path) throws IOException {
        FileUtils.mkdirs(new Path(path));
        HashMap<String, Integer> extraMetadata = new HashMap<String, Integer>();
        extraMetadata.put("numStages", stages.size());
        ReadWriteUtils.saveMetadata(pipeline, path, extraMetadata);
        int numStages = stages.size();
        for (int i = 0; i < numStages; ++i) {
            String stagePath = FileUtils.getPathForPipelineStage(i, numStages, path);
            stages.get(i).save(stagePath);
        }
    }

    public static List<Stage<?>> loadPipeline(StreamTableEnvironment tEnv, String path, String expectedClassName) throws IOException {
        Map<String, ?> metadata = FileUtils.loadMetadata(path, expectedClassName);
        int numStages = (Integer)metadata.get("numStages");
        ArrayList stages = new ArrayList(numStages);
        for (int i = 0; i < numStages; ++i) {
            String stagePath = FileUtils.getPathForPipelineStage(i, numStages, path);
            stages.add(ReadWriteUtils.loadStage(tEnv, stagePath));
        }
        return stages;
    }

    public static void saveGraph(Stage<?> graph, GraphData graphData, String path) throws IOException {
        FileUtils.mkdirs(new Path(path));
        HashMap<String, Map<String, Object>> extraMetadata = new HashMap<String, Map<String, Object>>();
        extraMetadata.put("graphData", graphData.toMap());
        ReadWriteUtils.saveMetadata(graph, path, extraMetadata);
        int maxNodeId = graphData.nodes.stream().map(node -> node.nodeId).max(Comparator.naturalOrder()).orElse(-1);
        for (GraphNode node2 : graphData.nodes) {
            String stagePath = FileUtils.getPathForPipelineStage(node2.nodeId, maxNodeId + 1, path);
            node2.stage.save(stagePath);
        }
    }

    public static Stage<?> loadGraph(StreamTableEnvironment tEnv, String path, String expectedClassName) throws IOException {
        Map<String, ?> metadata = FileUtils.loadMetadata(path, expectedClassName);
        GraphData graphData = GraphData.fromMap((Map)metadata.get("graphData"));
        int maxNodeId = graphData.nodes.stream().map(node -> node.nodeId).max(Comparator.naturalOrder()).orElse(-1);
        for (GraphNode node2 : graphData.nodes) {
            String stagePath = FileUtils.getPathForPipelineStage(node2.nodeId, maxNodeId + 1, path);
            node2.stage = ReadWriteUtils.loadStage(tEnv, stagePath);
        }
        if (expectedClassName.equals(GraphModel.class.getName())) {
            return new GraphModel(graphData.nodes, graphData.modelInputIds, graphData.outputIds, graphData.inputModelDataIds, graphData.outputModelDataIds);
        }
        Preconditions.checkState((boolean)expectedClassName.equals(Graph.class.getName()));
        return new Graph(graphData.nodes, graphData.estimatorInputIds, graphData.modelInputIds, graphData.outputIds, graphData.inputModelDataIds, graphData.outputModelDataIds);
    }

    public static <T extends Stage<T>> T loadStageParam(String path) throws IOException {
        try {
            return (T)((Stage)ParamUtils.instantiateWithParams(FileUtils.loadMetadata(path, "")));
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Failed to load stage.", e);
        }
    }

    public static Stage<?> loadStage(StreamTableEnvironment tEnv, String path) throws IOException {
        Map<String, ?> metadata = FileUtils.loadMetadata(path, "");
        String className = (String)metadata.get("className");
        try {
            Class<?> clazz = Class.forName(className);
            Method method = clazz.getMethod("load", StreamTableEnvironment.class, String.class);
            method.setAccessible(true);
            return (Stage)method.invoke(null, tEnv, path);
        }
        catch (NoSuchMethodException e) {
            String methodName = String.format("%s::load(StreamTableEnvironment, String)", className);
            throw new RuntimeException("Failed to load stage because the static method " + methodName + " is not implemented.", e);
        }
        catch (ClassNotFoundException | IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException("Failed to load stage.", e);
        }
    }

    public static <T> void saveModelData(DataStream<T> model, String path, Encoder<T> modelEncoder) {
        FileSink sink = ((FileSink.DefaultRowFormatBuilder)((FileSink.DefaultRowFormatBuilder)FileSink.forRowFormat((Path)FileUtils.getDataPath(path), modelEncoder).withRollingPolicy((RollingPolicy)OnCheckpointRollingPolicy.build())).withBucketAssigner((BucketAssigner)new BasePathBucketAssigner())).build();
        model.sinkTo((Sink)sink);
    }

    public static <T> Table loadModelData(StreamTableEnvironment tEnv, String path, SimpleStreamFormat<T> modelDecoder) {
        StreamExecutionEnvironment env = TableUtils.getExecutionEnvironment(tEnv);
        FileSource source = FileSource.forRecordStreamFormat(modelDecoder, (Path[])new Path[]{FileUtils.getDataPath(path)}).build();
        DataStreamSource modelDataStream = env.fromSource((Source)source, WatermarkStrategy.noWatermarks(), "modelData");
        return tEnv.fromDataStream((DataStream)modelDataStream);
    }
}

