/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.statefun.flink.core.di;

import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.flink.statefun.flink.core.di.ObjectContainer;

public final class Lazy<T> {
    private final Class<T> type;
    private final String label;
    private ObjectContainer container;
    @Nullable
    private T instance;

    public Lazy(Class<T> type) {
        this(type, null);
    }

    public Lazy(Class<T> type, String label) {
        this.type = type;
        this.label = label;
    }

    public Lazy(T instance) {
        this(instance.getClass(), null);
        this.instance = instance;
    }

    Lazy<T> withContainer(ObjectContainer container) {
        this.container = Objects.requireNonNull(container);
        return this;
    }

    public T get() {
        T instance = this.instance;
        if (instance == null) {
            this.instance = instance = this.container.get(this.type, this.label);
        }
        return instance;
    }
}

