/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.statefun.flink.core.di;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.statefun.flink.core.di.Inject;
import org.apache.flink.statefun.flink.core.di.Label;
import org.apache.flink.statefun.flink.core.di.Lazy;

@Internal
public class ObjectContainer {
    private final Map<Key, Supplier<Object>> factories = new HashMap<Key, Supplier<Object>>();
    private final Map<Key, Object> instances = new HashMap<Key, Object>();

    public <T> void add(T singleton) {
        Class<?> type = singleton.getClass();
        this.factories.put(new Key(type), () -> singleton);
    }

    public <T> void add(Class<T> type) {
        this.factories.put(new Key(type), () -> this.createReflectively(type));
    }

    public <T> void add(String label, Class<? super T> type, T singleton) {
        this.factories.put(new Key(type, label), () -> singleton);
    }

    public <T> void add(String label, Class<? super T> type, Class<?> actual) {
        this.factories.put(new Key(type, label), () -> this.createReflectively(actual));
    }

    public <T, ET> void addAlias(String newLabel, Class<? super T> newType, String existingLabel, Class<? super ET> existingType) {
        this.factories.put(new Key(newType, newLabel), () -> this.get(existingType, existingLabel));
    }

    public <T> void add(String label, Lazy<T> lazyValue) {
        this.factories.put(new Key(Lazy.class, label), () -> lazyValue.withContainer(this));
    }

    public <T> T get(Class<T> type) {
        return this.get(type, null);
    }

    public <T> T get(Class<T> type, String label) {
        Key key = new Key(type, label);
        return this.getOrCreateInstance(key);
    }

    private <T> T getOrCreateInstance(Key key) {
        Object instance = this.instances.get(key);
        if (instance == null) {
            instance = this.create(key);
            this.instances.put(key, instance);
        }
        return (T)instance;
    }

    private Object create(Key key) {
        Supplier<Object> factory = this.factories.get(key);
        if (factory == null) {
            throw new IllegalArgumentException("was not able to find a factory for " + key);
        }
        return factory.get();
    }

    private Object createReflectively(Class<?> type) {
        Constructor<?> constructor = ObjectContainer.findConstructorForInjection(type);
        Class<?>[] dependencies = constructor.getParameterTypes();
        Annotation[][] annotations = constructor.getParameterAnnotations();
        Object[] resolvedDependencies = new Object[dependencies.length];
        int i = 0;
        for (Class<?> dependency : dependencies) {
            String label = ObjectContainer.findLabel(annotations[i]);
            Key key = new Key(dependency, label);
            resolvedDependencies[i] = this.getOrCreateInstance(key);
            ++i;
        }
        try {
            constructor.setAccessible(true);
            return constructor.newInstance(resolvedDependencies);
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    @Nullable
    private static String findLabel(Annotation[] annotations) {
        for (Annotation annotation : annotations) {
            if (annotation.annotationType() != Label.class) continue;
            return ((Label)annotation).value();
        }
        return null;
    }

    private static Constructor<?> findConstructorForInjection(Class<?> type) {
        Constructor<?>[] constructors = type.getDeclaredConstructors();
        Constructor<?> defaultCont = null;
        for (Constructor<?> constructor : constructors) {
            Inject annotation = constructor.getAnnotation(Inject.class);
            if (annotation != null) {
                return constructor;
            }
            if (constructor.getParameterCount() != 0) continue;
            defaultCont = constructor;
        }
        if (defaultCont != null) {
            return defaultCont;
        }
        throw new RuntimeException("not injectable type " + type);
    }

    private static final class Key {
        final Class<?> type;
        @Nullable
        final String label;

        Key(Class<?> type, @Nullable String label) {
            this.type = type;
            this.label = label;
        }

        Key(Class<?> type) {
            this(type, null);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Key key = (Key)o;
            return Objects.equals(this.type, key.type) && Objects.equals(this.label, key.label);
        }

        public int hashCode() {
            return Objects.hash(this.type, this.label);
        }

        public String toString() {
            return "Key{type=" + this.type + ", label='" + this.label + '\'' + '}';
        }
    }
}

