/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.statefun.flink.core.feedback;

import java.io.OutputStream;
import java.util.Objects;
import java.util.OptionalLong;
import java.util.concurrent.Executor;
import org.apache.flink.api.common.operators.MailboxExecutor;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.runtime.io.disk.iomanager.IOManager;
import org.apache.flink.runtime.state.KeyGroupStatePartitionStreamProvider;
import org.apache.flink.runtime.state.StateInitializationContext;
import org.apache.flink.runtime.state.StateSnapshotContext;
import org.apache.flink.statefun.flink.core.common.MailboxExecutorFacade;
import org.apache.flink.statefun.flink.core.common.SerializableFunction;
import org.apache.flink.statefun.flink.core.feedback.Checkpoints;
import org.apache.flink.statefun.flink.core.feedback.FeedbackChannel;
import org.apache.flink.statefun.flink.core.feedback.FeedbackChannelBroker;
import org.apache.flink.statefun.flink.core.feedback.FeedbackConsumer;
import org.apache.flink.statefun.flink.core.feedback.FeedbackKey;
import org.apache.flink.statefun.flink.core.feedback.SubtaskFeedbackKey;
import org.apache.flink.statefun.flink.core.logger.Loggers;
import org.apache.flink.statefun.flink.core.logger.UnboundedFeedbackLogger;
import org.apache.flink.statefun.flink.core.logger.UnboundedFeedbackLoggerFactory;
import org.apache.flink.streaming.api.operators.AbstractStreamOperator;
import org.apache.flink.streaming.api.operators.ChainingStrategy;
import org.apache.flink.streaming.api.operators.OneInputStreamOperator;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.streaming.runtime.tasks.ProcessingTimeService;
import org.apache.flink.util.IOUtils;

public final class FeedbackUnionOperator<T>
extends AbstractStreamOperator<T>
implements FeedbackConsumer<T>,
OneInputStreamOperator<T, T> {
    private static final long serialVersionUID = 1L;
    private final FeedbackKey<T> feedbackKey;
    private final SerializableFunction<T, OptionalLong> isBarrierMessage;
    private final SerializableFunction<T, ?> keySelector;
    private final long totalMemoryUsedForFeedbackCheckpointing;
    private final TypeSerializer<T> elementSerializer;
    private transient Checkpoints<T> checkpoints;
    private transient boolean closedOrDisposed;
    private transient MailboxExecutor mailboxExecutor;
    private transient StreamRecord<T> reusable;

    FeedbackUnionOperator(FeedbackKey<T> feedbackKey, SerializableFunction<T, OptionalLong> isBarrierMessage, SerializableFunction<T, ?> keySelector, long totalMemoryUsedForFeedbackCheckpointing, TypeSerializer<T> elementSerializer, MailboxExecutor mailboxExecutor, ProcessingTimeService processingTimeService) {
        this.feedbackKey = Objects.requireNonNull(feedbackKey);
        this.isBarrierMessage = Objects.requireNonNull(isBarrierMessage);
        this.keySelector = Objects.requireNonNull(keySelector);
        this.totalMemoryUsedForFeedbackCheckpointing = totalMemoryUsedForFeedbackCheckpointing;
        this.elementSerializer = Objects.requireNonNull(elementSerializer);
        this.mailboxExecutor = Objects.requireNonNull(mailboxExecutor);
        this.chainingStrategy = ChainingStrategy.ALWAYS;
        this.processingTimeService = processingTimeService;
    }

    public void processElement(StreamRecord<T> streamRecord) {
        this.sendDownstream(streamRecord.getValue());
    }

    @Override
    public void processFeedback(T element) {
        if (this.closedOrDisposed) {
            return;
        }
        OptionalLong maybeCheckpoint = (OptionalLong)this.isBarrierMessage.apply(element);
        if (maybeCheckpoint.isPresent()) {
            this.checkpoints.commitCheckpointsUntil(maybeCheckpoint.getAsLong());
        } else {
            this.sendDownstream(element);
            this.checkpoints.append(element);
        }
    }

    public void initializeState(StateInitializationContext context) throws Exception {
        super.initializeState(context);
        IOManager ioManager = this.getContainingTask().getEnvironment().getIOManager();
        int maxParallelism = this.getRuntimeContext().getMaxNumberOfParallelSubtasks();
        this.reusable = new StreamRecord(null);
        UnboundedFeedbackLoggerFactory<?> feedbackLoggerFactory = Loggers.unboundedSpillableLoggerFactory(ioManager, maxParallelism, this.totalMemoryUsedForFeedbackCheckpointing, this.elementSerializer, this.keySelector);
        this.checkpoints = new Checkpoints(feedbackLoggerFactory::create);
        UnboundedFeedbackLogger<?> logger = feedbackLoggerFactory.create();
        for (KeyGroupStatePartitionStreamProvider keyedStateInput : context.getRawKeyedStateInputs()) {
            logger.replyLoggedEnvelops(keyedStateInput.getStream(), this);
        }
        this.registerFeedbackConsumer(new MailboxExecutorFacade(this.mailboxExecutor, "Feedback Consumer"));
    }

    public void snapshotState(StateSnapshotContext context) throws Exception {
        super.snapshotState(context);
        this.checkpoints.startLogging(context.getCheckpointId(), (OutputStream)context.getRawKeyedOperatorStateOutput());
    }

    protected boolean isUsingCustomRawKeyedState() {
        return true;
    }

    public void close() throws Exception {
        this.closeInternally();
        super.close();
    }

    private void closeInternally() {
        IOUtils.closeQuietly(this.checkpoints);
        this.checkpoints = null;
        this.closedOrDisposed = true;
    }

    private void registerFeedbackConsumer(Executor mailboxExecutor) {
        int indexOfThisSubtask = this.getRuntimeContext().getIndexOfThisSubtask();
        int attemptNum = this.getRuntimeContext().getAttemptNumber();
        SubtaskFeedbackKey<T> key = this.feedbackKey.withSubTaskIndex(indexOfThisSubtask, attemptNum);
        FeedbackChannelBroker broker = FeedbackChannelBroker.get();
        FeedbackChannel<T> channel = broker.getChannel(key);
        channel.registerConsumer(this, mailboxExecutor);
    }

    private void sendDownstream(T element) {
        this.reusable.replace(element);
        this.output.collect(this.reusable);
    }
}

