/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.statefun.flink.core.functions;

import java.util.Map;
import java.util.Objects;
import org.apache.flink.api.common.operators.MailboxExecutor;
import org.apache.flink.statefun.flink.core.StatefulFunctionsConfig;
import org.apache.flink.statefun.flink.core.functions.FunctionGroupOperator;
import org.apache.flink.statefun.flink.core.message.Message;
import org.apache.flink.statefun.sdk.io.EgressIdentifier;
import org.apache.flink.streaming.api.operators.ChainingStrategy;
import org.apache.flink.streaming.api.operators.OneInputStreamOperatorFactory;
import org.apache.flink.streaming.api.operators.StreamOperator;
import org.apache.flink.streaming.api.operators.StreamOperatorParameters;
import org.apache.flink.streaming.api.operators.YieldingOperatorFactory;
import org.apache.flink.util.OutputTag;

public final class FunctionGroupDispatchFactory
implements OneInputStreamOperatorFactory<Message, Message>,
YieldingOperatorFactory<Message> {
    private static final long serialVersionUID = 1L;
    private final StatefulFunctionsConfig configuration;
    private final Map<EgressIdentifier<?>, OutputTag<Object>> sideOutputs;
    private transient MailboxExecutor mailboxExecutor;

    public FunctionGroupDispatchFactory(StatefulFunctionsConfig configuration, Map<EgressIdentifier<?>, OutputTag<Object>> sideOutputs) {
        this.configuration = configuration;
        this.sideOutputs = sideOutputs;
    }

    public void setMailboxExecutor(MailboxExecutor mailboxExecutor) {
        this.mailboxExecutor = Objects.requireNonNull(mailboxExecutor, "Mailbox executor can't be NULL");
    }

    public <T extends StreamOperator<Message>> T createStreamOperator(StreamOperatorParameters<Message> streamOperatorParameters) {
        FunctionGroupOperator fn = new FunctionGroupOperator(this.sideOutputs, this.configuration, this.mailboxExecutor, ChainingStrategy.ALWAYS, streamOperatorParameters.getProcessingTimeService());
        fn.setup(streamOperatorParameters.getContainingTask(), streamOperatorParameters.getStreamConfig(), streamOperatorParameters.getOutput());
        return (T)((Object)fn);
    }

    public void setChainingStrategy(ChainingStrategy chainingStrategy) {
    }

    public ChainingStrategy getChainingStrategy() {
        return ChainingStrategy.ALWAYS;
    }

    public Class<? extends StreamOperator> getStreamOperatorClass(ClassLoader classLoader) {
        return FunctionGroupOperator.class;
    }
}

