/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.statefun.flink.core.httpfn;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.net.SocketFactory;
import okhttp3.Dns;
import okhttp3.OkHttpClient;
import org.apache.flink.util.IOUtils;
import org.newsclub.net.unix.AFUNIXSocket;
import org.newsclub.net.unix.AFUNIXSocketAddress;

final class OkHttpUnixSocketBridge {
    private OkHttpUnixSocketBridge() {
    }

    static void configureUnixDomainSocket(OkHttpClient.Builder builder, File unixSocketFile) {
        builder.socketFactory((SocketFactory)new UnixSocketFactory(unixSocketFile)).dns((Dns)ConstantDnsLookup.INSTANCE);
    }

    private static final class UnixSocket
    extends Socket {
        private final File unixSocketFile;
        private AFUNIXSocket delegate;

        UnixSocket(File unixSocketFile) {
            this.unixSocketFile = Objects.requireNonNull(unixSocketFile);
        }

        @Override
        public void connect(SocketAddress endpoint, int timeout) throws IOException {
            this.delegate = AFUNIXSocket.newInstance();
            this.delegate.connect((SocketAddress)new AFUNIXSocketAddress(this.unixSocketFile), timeout);
            this.delegate.setSoTimeout(timeout);
        }

        @Override
        public void bind(SocketAddress bindpoint) throws IOException {
            this.delegate.bind(bindpoint);
        }

        @Override
        public boolean isConnected() {
            return this.delegate != null && this.delegate.isConnected();
        }

        @Override
        public OutputStream getOutputStream() throws IOException {
            return this.delegate.getOutputStream();
        }

        @Override
        public InputStream getInputStream() throws IOException {
            return this.delegate.getInputStream();
        }

        @Override
        public synchronized void close() {
            IOUtils.closeSocket((Socket)this.delegate);
            this.delegate = null;
        }

        @Override
        public boolean isClosed() {
            return this.delegate.isClosed();
        }

        @Override
        public synchronized void setSoTimeout(int timeout) {
        }
    }

    private static final class UnixSocketFactory
    extends SocketFactory {
        private final File unixSocketFile;

        public UnixSocketFactory(File unixSocketFile) {
            this.unixSocketFile = Objects.requireNonNull(unixSocketFile);
        }

        @Override
        public Socket createSocket() {
            return new UnixSocket(this.unixSocketFile);
        }

        @Override
        public Socket createSocket(String s, int i) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Socket createSocket(String s, int i, InetAddress inetAddress, int i1) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Socket createSocket(InetAddress inetAddress, int i) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Socket createSocket(InetAddress inetAddress, int i, InetAddress inetAddress1, int i1) {
            throw new UnsupportedOperationException();
        }
    }

    private static enum ConstantDnsLookup implements Dns
    {
        INSTANCE;


        public List<InetAddress> lookup(String hostname) throws UnknownHostException {
            InetAddress address = InetAddress.getByAddress(hostname, new byte[]{0, 0, 0, 0});
            return Collections.singletonList(address);
        }
    }
}

