/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.statefun.flink.core.httpfn;

import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import okhttp3.ConnectionPool;
import okhttp3.Dispatcher;
import okhttp3.OkHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class OkHttpUtils {
    private static final Logger LOG = LoggerFactory.getLogger(OkHttpUtils.class);

    private OkHttpUtils() {
    }

    static OkHttpClient newClient() {
        Dispatcher dispatcher = new Dispatcher();
        dispatcher.setMaxRequestsPerHost(Integer.MAX_VALUE);
        dispatcher.setMaxRequests(Integer.MAX_VALUE);
        ConnectionPool connectionPool = new ConnectionPool(1024, 1L, TimeUnit.MINUTES);
        return new OkHttpClient.Builder().dispatcher(dispatcher).connectionPool(connectionPool).followRedirects(true).followSslRedirects(true).retryOnConnectionFailure(true).build();
    }

    static void closeSilently(@Nullable OkHttpClient client) {
        if (client == null) {
            return;
        }
        Dispatcher dispatcher = client.dispatcher();
        try {
            dispatcher.executorService().shutdownNow();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            dispatcher.cancelAll();
        }
        catch (Throwable throwable) {
            LOG.warn("Exception caught while trying to close the HTTP client", throwable);
        }
        try {
            client.connectionPool().evictAll();
        }
        catch (Throwable throwable) {
            LOG.warn("Exception caught while trying to close the HTTP connection pool", throwable);
        }
    }
}

