/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.statefun.flink.core.message;

import java.util.Objects;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.statefun.flink.core.message.Message;
import org.apache.flink.statefun.flink.core.message.MessageFactoryKey;
import org.apache.flink.statefun.flink.core.message.MessageTypeSerializer;

public class MessageTypeInformation
extends TypeInformation<Message> {
    private static final long serialVersionUID = 2L;
    private final MessageFactoryKey messageFactoryKey;

    public MessageTypeInformation(MessageFactoryKey messageFactoryKey) {
        this.messageFactoryKey = Objects.requireNonNull(messageFactoryKey);
    }

    public boolean isBasicType() {
        return false;
    }

    public boolean isTupleType() {
        return false;
    }

    public int getArity() {
        return 0;
    }

    public int getTotalFields() {
        return 0;
    }

    public Class<Message> getTypeClass() {
        return Message.class;
    }

    public boolean isKeyType() {
        return false;
    }

    public TypeSerializer<Message> createSerializer(ExecutionConfig executionConfig) {
        return new MessageTypeSerializer(this.messageFactoryKey);
    }

    public String toString() {
        return String.format("MessageTypeInformation(%s: %s", new Object[]{this.messageFactoryKey.getType(), this.messageFactoryKey.getCustomPayloadSerializerClassName()});
    }

    public boolean equals(Object o) {
        return o instanceof MessageTypeInformation;
    }

    public int hashCode() {
        return ((Object)((Object)this)).getClass().hashCode();
    }

    public boolean canEqual(Object o) {
        return o instanceof MessageTypeInformation;
    }
}

