/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.statefun.flink.core.message;

import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.flink.statefun.flink.core.message.RoutableMessage;
import org.apache.flink.statefun.flink.core.message.SdkMessage;
import org.apache.flink.statefun.sdk.Address;
import org.apache.flink.statefun.sdk.FunctionType;

public final class RoutableMessageBuilder {
    @Nullable
    private Address source;
    private Address target;
    private Object payload;

    public static RoutableMessageBuilder builder() {
        return new RoutableMessageBuilder();
    }

    private RoutableMessageBuilder() {
    }

    public RoutableMessageBuilder withTargetAddress(FunctionType functionType, String id) {
        return this.withTargetAddress(new Address(functionType, id));
    }

    public RoutableMessageBuilder withTargetAddress(Address target) {
        this.target = Objects.requireNonNull(target);
        return this;
    }

    public RoutableMessageBuilder withSourceAddress(FunctionType functionType, String id) {
        return this.withSourceAddress(new Address(functionType, id));
    }

    public RoutableMessageBuilder withSourceAddress(@Nullable Address from) {
        this.source = from;
        return this;
    }

    public RoutableMessageBuilder withMessageBody(Object payload) {
        this.payload = Objects.requireNonNull(payload);
        return this;
    }

    public RoutableMessage build() {
        return new SdkMessage(this.source, this.target, this.payload);
    }
}

