/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.statefun.flink.core.message;

import java.io.IOException;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;
import javax.annotation.Nullable;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.statefun.flink.core.generated.Envelope;
import org.apache.flink.statefun.flink.core.generated.EnvelopeAddress;
import org.apache.flink.statefun.flink.core.message.Message;
import org.apache.flink.statefun.flink.core.message.MessageFactory;
import org.apache.flink.statefun.sdk.Address;

final class SdkMessage
implements Message {
    private final Address target;
    @Nullable
    private final Address source;
    @Nullable
    private final String cancellationToken;
    @Nullable
    private Envelope cachedEnvelope;
    private Object payload;

    SdkMessage(@Nullable Address source, Address target, Object payload) {
        this(source, target, payload, null);
    }

    SdkMessage(@Nullable Address source, Address target, Object payload, @Nullable String cancellationToken) {
        this.source = source;
        this.target = Objects.requireNonNull(target);
        this.payload = Objects.requireNonNull(payload);
        this.cancellationToken = cancellationToken;
    }

    @Override
    @Nullable
    public Address source() {
        return this.source;
    }

    @Override
    public Address target() {
        return this.target;
    }

    @Override
    public Object payload(MessageFactory factory, ClassLoader targetClassLoader) {
        if (!SdkMessage.sameClassLoader(targetClassLoader, this.payload)) {
            this.payload = factory.copyUserMessagePayload(targetClassLoader, this.payload);
        }
        return this.payload;
    }

    @Override
    public OptionalLong isBarrierMessage() {
        return OptionalLong.empty();
    }

    @Override
    public Optional<String> cancellationToken() {
        return Optional.ofNullable(this.cancellationToken);
    }

    @Override
    public Message copy(MessageFactory factory) {
        return new SdkMessage(this.source, this.target, this.payload, this.cancellationToken);
    }

    @Override
    public void writeTo(MessageFactory factory, DataOutputView target) throws IOException {
        Envelope envelope = this.envelope(factory);
        factory.serializeEnvelope(envelope, target);
    }

    private Envelope envelope(MessageFactory factory) {
        if (this.cachedEnvelope == null) {
            Envelope.Builder builder = Envelope.newBuilder();
            if (this.source != null) {
                builder.setSource(SdkMessage.sdkAddressToProtobufAddress(this.source));
            }
            builder.setTarget(SdkMessage.sdkAddressToProtobufAddress(this.target));
            builder.setPayload(factory.serializeUserMessagePayload(this.payload));
            if (this.cancellationToken != null) {
                builder.setCancellationToken(this.cancellationToken);
            }
            this.cachedEnvelope = builder.build();
        }
        return this.cachedEnvelope;
    }

    private static boolean sameClassLoader(ClassLoader targetClassLoader, Object payload) {
        return payload.getClass().getClassLoader() == targetClassLoader;
    }

    private static EnvelopeAddress sdkAddressToProtobufAddress(Address source) {
        return EnvelopeAddress.newBuilder().setNamespace(source.type().namespace()).setType(source.type().name()).setId(source.id()).build();
    }
}

