/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.statefun.flink.core.nettyclient;

import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URISyntaxException;

final class Endpoint {
    private final String queryPath;
    private final InetSocketAddress serviceAddress;
    private final boolean useTls;

    Endpoint(URI endpointUrl) {
        Endpoint.requireValidEndpointUri(endpointUrl);
        this.useTls = endpointUrl.getScheme().equalsIgnoreCase("https");
        this.queryPath = Endpoint.computeQueryPath(endpointUrl);
        this.serviceAddress = InetSocketAddress.createUnresolved(endpointUrl.getHost(), Endpoint.endpointPort(endpointUrl));
    }

    public String queryPath() {
        return this.queryPath;
    }

    public InetSocketAddress serviceAddress() {
        return this.serviceAddress;
    }

    public boolean useTls() {
        return this.useTls;
    }

    private static int endpointPort(URI endpoint) {
        int port = endpoint.getPort();
        if (port > 0) {
            return port;
        }
        if (endpoint.getScheme().equalsIgnoreCase("https")) {
            return 443;
        }
        return 80;
    }

    private static String computeQueryPath(URI endpoint) {
        String fragment;
        String query;
        String uri = endpoint.getPath();
        if (uri == null || uri.isEmpty()) {
            uri = "/";
        }
        if ((query = endpoint.getQuery()) != null) {
            uri = uri + "?" + query;
        }
        if ((fragment = endpoint.getFragment()) != null) {
            uri = uri + "#" + fragment;
        }
        return uri;
    }

    private static void requireValidEndpointUri(URI endpointUrl) {
        try {
            endpointUrl.parseServerAuthority();
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException(e);
        }
    }
}

