/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.statefun.flink.core.nettyclient;

import java.net.InetSocketAddress;
import java.util.ArrayList;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.HttpHeaderNames;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.HttpHeaderValues;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.ReadOnlyHttpHeaders;
import org.apache.flink.shaded.netty4.io.netty.util.AsciiString;

final class NettyHeaders {
    private static final AsciiString USER_AGENT = AsciiString.cached((String)"statefun");
    static final ReadOnlyHttpHeaders EMPTY = new ReadOnlyHttpHeaders(false, new CharSequence[0]);

    NettyHeaders() {
    }

    static ReadOnlyHttpHeaders defaultHeadersFor(InetSocketAddress service) {
        AsciiString serviceHost = service.getPort() == 443 || service.getPort() == 80 ? AsciiString.cached((String)service.getHostString()) : AsciiString.cached((String)(service.getHostString() + ":" + service.getPort()));
        ArrayList<AsciiString> headers = new ArrayList<AsciiString>();
        headers.add(HttpHeaderNames.CONTENT_TYPE);
        headers.add(HttpHeaderValues.APPLICATION_OCTET_STREAM);
        headers.add(HttpHeaderNames.ACCEPT);
        headers.add(HttpHeaderValues.APPLICATION_OCTET_STREAM);
        headers.add(HttpHeaderNames.ACCEPT_ENCODING);
        headers.add(HttpHeaderValues.GZIP_DEFLATE);
        headers.add(HttpHeaderNames.CONNECTION);
        headers.add(HttpHeaderValues.KEEP_ALIVE);
        headers.add(HttpHeaderNames.USER_AGENT);
        headers.add(USER_AGENT);
        headers.add(HttpHeaderNames.HOST);
        headers.add(serviceHost);
        headers.add(HttpHeaderNames.CONTENT_LENGTH);
        headers.add(AsciiString.cached((String)"0"));
        AsciiString[] kvPairs = headers.toArray(new AsciiString[0]);
        return new ReadOnlyHttpHeaders(false, (CharSequence[])kvPairs);
    }
}

