/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.statefun.flink.core.nettyclient;

import java.io.Closeable;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import javax.annotation.Nullable;
import org.apache.flink.shaded.netty4.io.netty.channel.Channel;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.ReadOnlyHttpHeaders;
import org.apache.flink.statefun.flink.core.metrics.RemoteInvocationMetrics;
import org.apache.flink.statefun.flink.core.nettyclient.NettyClientService;
import org.apache.flink.statefun.flink.core.nettyclient.OnChannelThread;
import org.apache.flink.statefun.flink.core.nettyclient.OnClientThread;
import org.apache.flink.statefun.flink.core.nettyclient.OnFlinkThread;
import org.apache.flink.statefun.flink.core.nettyclient.exceptions.RequestTimeoutException;
import org.apache.flink.statefun.flink.core.nettyclient.exceptions.ShutdownException;
import org.apache.flink.statefun.flink.core.reqreply.ToFunctionRequestSummary;
import org.apache.flink.statefun.sdk.reqreply.generated.FromFunction;
import org.apache.flink.statefun.sdk.reqreply.generated.ToFunction;
import org.apache.flink.util.IOUtils;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class NettyRequest {
    private static final Logger LOG = LoggerFactory.getLogger(NettyRequest.class);
    private static final AtomicReferenceFieldUpdater<NettyRequest, Channel> ATTEMPT_CHANNEL_CAS = AtomicReferenceFieldUpdater.newUpdater(NettyRequest.class, Channel.class, "attemptChannel");
    private final NettyClientService client;
    private final RemoteInvocationMetrics metrics;
    private final ToFunctionRequestSummary reqSummary;
    private final ToFunction toFunction;
    private final long requestCreatedNanos;
    private final CompletableFuture<FromFunction> result = new CompletableFuture();
    private long attemptStartedNanos;
    private int numberOfAttempts;
    @Nullable
    private Closeable retryTask;
    @Nullable
    private volatile Channel attemptChannel;

    @OnFlinkThread
    NettyRequest(NettyClientService client, RemoteInvocationMetrics metrics, ToFunctionRequestSummary requestSummary, ToFunction toFunction) {
        this.client = Objects.requireNonNull(client);
        this.reqSummary = Objects.requireNonNull(requestSummary);
        this.metrics = Objects.requireNonNull(metrics);
        this.toFunction = Objects.requireNonNull(toFunction);
        this.requestCreatedNanos = client.systemNanoTime();
    }

    @OnFlinkThread
    CompletableFuture<FromFunction> start() {
        this.client.runOnEventLoop(this::startAttempt);
        return this.result;
    }

    @OnChannelThread
    void complete(FromFunction fromFn) {
        try {
            this.onAttemptCompleted();
        }
        catch (Throwable t) {
            LOG.warn("Attempt cleanup failed", t);
        }
        this.onFinalCompleted(fromFn, null);
    }

    @OnClientThread
    @OnChannelThread
    void completeAttemptExceptionally(Throwable cause) {
        try {
            this.onAttemptCompleted();
        }
        catch (Throwable t) {
            LOG.warn("Attempt cleanup failed", t);
        }
        try {
            this.onAttemptCompletedExceptionally(cause);
        }
        catch (Throwable t) {
            this.onFinalCompleted(null, t);
        }
    }

    @OnClientThread
    private void startAttempt() {
        try {
            this.attemptStartedNanos = this.client.systemNanoTime();
            this.client.acquireChannel(this::onChannelAcquisitionComplete);
        }
        catch (Throwable throwable) {
            this.completeAttemptExceptionally(throwable);
        }
    }

    @OnChannelThread
    private void onChannelAcquisitionComplete(Channel ch, Throwable cause) {
        if (cause != null) {
            this.completeAttemptExceptionally(cause);
            return;
        }
        if (!ATTEMPT_CHANNEL_CAS.compareAndSet(this, null, ch)) {
            LOG.warn("BUG: Trying to acquire a new Netty channel, while still holding an existing one. Failing this request, but continuing processing others.");
            this.onFinalCompleted(null, new IllegalStateException("Unexpected request state, failing this request, but will try others."));
            return;
        }
        this.client.writeAndFlush(this, ch, this::onFirstWriteCompleted);
    }

    @OnChannelThread
    private void onFirstWriteCompleted(Void ignored, Throwable cause) {
        if (cause != null) {
            this.completeAttemptExceptionally(cause);
        }
    }

    @OnClientThread
    @OnChannelThread
    private void onAttemptCompleted() {
        Channel ch = ATTEMPT_CHANNEL_CAS.getAndSet(this, null);
        if (ch != null) {
            this.client.releaseChannel(ch);
        }
        long nanoElapsed = this.client.systemNanoTime() - this.attemptStartedNanos;
        long millisElapsed = TimeUnit.NANOSECONDS.toMillis(nanoElapsed);
        this.attemptStartedNanos = 0L;
        this.metrics.remoteInvocationLatency(millisElapsed);
        IOUtils.closeQuietly((AutoCloseable)this.retryTask);
        this.retryTask = null;
        ++this.numberOfAttempts;
    }

    @OnClientThread
    @OnChannelThread
    private void onAttemptCompletedExceptionally(Throwable cause) throws Throwable {
        this.metrics.remoteInvocationFailures();
        LOG.warn("Exception caught while trying to deliver a message: (attempt #" + (this.numberOfAttempts - 1) + ")" + this.reqSummary, cause);
        if (this.client.isShutdown()) {
            throw ShutdownException.INSTANCE;
        }
        long delayUntilNextAttempt = this.delayUntilNextAttempt();
        if (delayUntilNextAttempt < 0L) {
            throw RequestTimeoutException.INSTANCE;
        }
        this.analyzeCausalChain(cause);
        LOG.info("Retry #" + this.numberOfAttempts + " " + this.reqSummary + " ,About to sleep for " + TimeUnit.NANOSECONDS.toMillis(delayUntilNextAttempt));
        Preconditions.checkState((this.retryTask == null ? 1 : 0) != 0);
        this.retryTask = this.client.newTimeout(this::onAttemptBackoffTimer, delayUntilNextAttempt);
    }

    @OnClientThread
    private void onAttemptBackoffTimer() {
        if (this.delayUntilNextAttempt() < 0L) {
            this.completeAttemptExceptionally(RequestTimeoutException.INSTANCE);
        } else if (this.client.isShutdown()) {
            this.completeAttemptExceptionally(ShutdownException.INSTANCE);
        } else {
            this.startAttempt();
        }
    }

    @OnClientThread
    @OnChannelThread
    private void onFinalCompleted(FromFunction result, Throwable o) {
        if (o != null) {
            this.result.completeExceptionally(o);
        } else {
            this.result.complete(result);
        }
    }

    CompletableFuture<FromFunction> result() {
        return this.result;
    }

    long remainingRequestBudgetNanos() {
        long usedRequestBudget = this.client.systemNanoTime() - this.requestCreatedNanos;
        return this.client.totalRequestBudgetInNanos() - usedRequestBudget;
    }

    ToFunction toFunction() {
        return this.toFunction;
    }

    String uri() {
        return this.client.queryPath();
    }

    private void analyzeCausalChain(Throwable cause) throws Throwable {
        while (cause != null) {
            if (!this.isRetryable(cause)) {
                throw cause;
            }
            cause = cause.getCause();
        }
    }

    private boolean isRetryable(Throwable exception) {
        return !(exception instanceof ShutdownException) && !(exception instanceof RequestTimeoutException);
    }

    private long delayUntilNextAttempt() {
        long remainingRequestBudget = this.remainingRequestBudgetNanos();
        if (remainingRequestBudget <= 1000000L) {
            return -1L;
        }
        long delay = 2000000L * (1L << this.numberOfAttempts);
        return Math.min(delay, remainingRequestBudget);
    }

    public ReadOnlyHttpHeaders headers() {
        return this.client.headers();
    }
}

