/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.statefun.flink.core.nettyclient;

import java.net.URI;
import javax.annotation.Nullable;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.JsonProcessingException;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.TreeNode;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.node.ObjectNode;
import org.apache.flink.statefun.flink.common.json.StateFunObjectMapper;
import org.apache.flink.statefun.flink.core.nettyclient.NettyClient;
import org.apache.flink.statefun.flink.core.nettyclient.NettyRequestReplySpec;
import org.apache.flink.statefun.flink.core.nettyclient.NettySharedResources;
import org.apache.flink.statefun.flink.core.reqreply.RequestReplyClient;
import org.apache.flink.statefun.flink.core.reqreply.RequestReplyClientFactory;

public final class NettyRequestReplyClientFactory
implements RequestReplyClientFactory {
    @Nullable
    private transient NettySharedResources sharedNettyResources;
    private static final ObjectMapper OBJ_MAPPER = StateFunObjectMapper.create();

    @Override
    public RequestReplyClient createTransportClient(ObjectNode transportProperties, URI endpointUrl) {
        NettySharedResources resources = this.sharedNettyResources;
        if (resources == null) {
            this.sharedNettyResources = resources = new NettySharedResources();
        }
        NettyRequestReplySpec clientSpec = NettyRequestReplyClientFactory.parseTransportSpec(transportProperties);
        return NettyClient.from(resources, clientSpec, endpointUrl);
    }

    @Override
    public void cleanup() {
        NettySharedResources resources = this.sharedNettyResources;
        this.sharedNettyResources = null;
        if (resources != null) {
            resources.shutdownGracefully();
        }
    }

    private static NettyRequestReplySpec parseTransportSpec(ObjectNode transportProperties) {
        try {
            return (NettyRequestReplySpec)OBJ_MAPPER.treeToValue((TreeNode)transportProperties, NettyRequestReplySpec.class);
        }
        catch (JsonProcessingException e) {
            throw new IllegalStateException("Unable to parse Netty transport spec.", e);
        }
    }
}

