/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.ml.examples.feature;

import java.util.Arrays;
import org.apache.flink.ml.feature.stringindexer.IndexToStringModel;
import org.apache.flink.ml.feature.stringindexer.StringIndexerModelData;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.datastream.DataStreamSource;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.bridge.java.StreamTableEnvironment;
import org.apache.flink.types.Row;
import org.apache.flink.util.CloseableIterator;

public class IndexToStringModelExample {
    public static void main(String[] args) {
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        StreamTableEnvironment tEnv = StreamTableEnvironment.create((StreamExecutionEnvironment)env);
        StringIndexerModelData modelData = new StringIndexerModelData((String[][])new String[][]{{"a", "b", "c", "d"}, {"-1.0", "0.0", "1.0", "2.0"}});
        Table modelTable = tEnv.fromDataStream((DataStream)env.fromElements((Object[])new StringIndexerModelData[]{modelData})).as("stringArrays", new String[0]);
        DataStreamSource predictStream = env.fromElements((Object[])new Row[]{Row.of((Object[])new Object[]{0, 3}), Row.of((Object[])new Object[]{1, 2})});
        Table predictTable = tEnv.fromDataStream((DataStream)predictStream).as("inputCol1", new String[]{"inputCol2"});
        IndexToStringModel indexToStringModel = ((IndexToStringModel)((IndexToStringModel)new IndexToStringModel().setInputCols(new String[]{"inputCol1", "inputCol2"})).setOutputCols(new String[]{"outputCol1", "outputCol2"})).setModelData(new Table[]{modelTable});
        Table outputTable = indexToStringModel.transform(new Table[]{predictTable})[0];
        CloseableIterator it = outputTable.execute().collect();
        while (it.hasNext()) {
            Row row = (Row)it.next();
            int[] inputValues = new int[indexToStringModel.getInputCols().length];
            Object[] outputValues = new String[indexToStringModel.getInputCols().length];
            for (int i = 0; i < inputValues.length; ++i) {
                inputValues[i] = (Integer)row.getField(indexToStringModel.getInputCols()[i]);
                outputValues[i] = (String)row.getField(indexToStringModel.getOutputCols()[i]);
            }
            System.out.printf("Input Values: %s \tOutput Values: %s\n", Arrays.toString(inputValues), Arrays.toString(outputValues));
        }
    }
}

