/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.ml.examples.feature;

import org.apache.flink.ml.feature.randomsplitter.RandomSplitter;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.datastream.DataStreamSource;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.bridge.java.StreamTableEnvironment;
import org.apache.flink.types.Row;
import org.apache.flink.util.CloseableIterator;

public class RandomSplitterExample {
    public static void main(String[] args) {
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        StreamTableEnvironment tEnv = StreamTableEnvironment.create((StreamExecutionEnvironment)env);
        DataStreamSource inputStream = env.fromElements((Object[])new Row[]{Row.of((Object[])new Object[]{1, 10, 0}), Row.of((Object[])new Object[]{1, 10, 0}), Row.of((Object[])new Object[]{1, 10, 0}), Row.of((Object[])new Object[]{4, 10, 0}), Row.of((Object[])new Object[]{5, 10, 0}), Row.of((Object[])new Object[]{6, 10, 0}), Row.of((Object[])new Object[]{7, 10, 0}), Row.of((Object[])new Object[]{10, 10, 0}), Row.of((Object[])new Object[]{13, 10, 3})});
        Table inputTable = tEnv.fromDataStream((DataStream)inputStream).as("input", new String[0]);
        RandomSplitter splitter = (RandomSplitter)((RandomSplitter)new RandomSplitter().setWeights(new Double[]{4.0, 6.0})).setSeed(0L);
        Table[] outputTable = splitter.transform(new Table[]{inputTable});
        System.out.println("Split Result 1 (40%)");
        CloseableIterator it = outputTable[0].execute().collect();
        while (it.hasNext()) {
            System.out.printf("%s\n", it.next());
        }
        System.out.println("Split Result 2 (60%)");
        it = outputTable[1].execute().collect();
        while (it.hasNext()) {
            System.out.printf("%s\n", it.next());
        }
    }
}

