/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.ml.examples.util;

import java.util.List;
import org.apache.flink.streaming.api.functions.source.SourceFunction;
import org.apache.flink.types.Row;

public class PeriodicSourceFunction
implements SourceFunction<Row> {
    private final long interval;
    private final List<List<Row>> data;
    private int index = 0;
    private boolean isRunning = true;

    public PeriodicSourceFunction(long interval, List<List<Row>> data) {
        this.interval = interval;
        this.data = data;
    }

    public void run(SourceFunction.SourceContext<Row> sourceContext) throws Exception {
        while (this.isRunning) {
            for (Row data : this.data.get(this.index)) {
                sourceContext.collect((Object)data);
            }
            Thread.sleep(this.interval);
            this.index = (this.index + 1) % this.data.size();
        }
    }

    public void cancel() {
        this.isRunning = false;
    }
}

