/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.accumulators;

import org.apache.flink.annotation.Public;
import org.apache.flink.api.common.accumulators.Accumulator;
import org.apache.flink.api.common.accumulators.SimpleAccumulator;

@Public
public class AverageAccumulator
implements SimpleAccumulator<Double> {
    private static final long serialVersionUID = 3672555084179165255L;
    private long count;
    private double sum;

    @Override
    public void add(Double value) {
        ++this.count;
        this.sum += value.doubleValue();
    }

    @Override
    public void add(double value) {
        ++this.count;
        this.sum += value;
    }

    @Override
    public void add(long value) {
        ++this.count;
        this.sum += (double)value;
    }

    @Override
    public void add(int value) {
        ++this.count;
        this.sum += (double)value;
    }

    @Override
    public Double getLocalValue() {
        if (this.count == 0L) {
            return 0.0;
        }
        return this.sum / (double)this.count;
    }

    @Override
    public void resetLocal() {
        this.count = 0L;
        this.sum = 0.0;
    }

    @Override
    public void merge(Accumulator<Double, Double> other) {
        if (other instanceof AverageAccumulator) {
            AverageAccumulator avg = (AverageAccumulator)other;
            this.count += avg.count;
            this.sum += avg.sum;
        } else {
            throw new IllegalArgumentException("The merged accumulator must be AverageAccumulator.");
        }
    }

    public AverageAccumulator clone() {
        AverageAccumulator average = new AverageAccumulator();
        average.count = this.count;
        average.sum = this.sum;
        return average;
    }

    public String toString() {
        return "AverageAccumulator " + this.getLocalValue() + " for " + this.count + " elements";
    }
}

