/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.dispatcher;

import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.configuration.RestOptions;
import org.apache.flink.runtime.rest.handler.async.CompletedOperationCache;
import org.apache.flink.runtime.rest.handler.job.AsynchronousJobOperationKey;

public class DispatcherOperationCaches {
    private final CompletedOperationCache<AsynchronousJobOperationKey, String> savepointTriggerCache;

    @VisibleForTesting
    public DispatcherOperationCaches() {
        this(RestOptions.ASYNC_OPERATION_STORE_DURATION.defaultValue());
    }

    @VisibleForTesting
    public DispatcherOperationCaches(Duration cacheDuration) {
        this.savepointTriggerCache = new CompletedOperationCache(cacheDuration);
    }

    public CompletedOperationCache<AsynchronousJobOperationKey, String> getSavepointTriggerCache() {
        return this.savepointTriggerCache;
    }

    public CompletableFuture<Void> shutdownCaches() {
        return this.savepointTriggerCache.closeAsync();
    }
}

