/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.operators;

import org.apache.flink.metrics.Counter;
import org.apache.flink.streaming.api.operators.Output;
import org.apache.flink.streaming.api.watermark.Watermark;
import org.apache.flink.streaming.runtime.streamrecord.LatencyMarker;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.streaming.runtime.watermarkstatus.WatermarkStatus;
import org.apache.flink.util.OutputTag;

public class CountingOutput<OUT>
implements Output<StreamRecord<OUT>> {
    private final Output<StreamRecord<OUT>> output;
    private final Counter numRecordsOut;

    public CountingOutput(Output<StreamRecord<OUT>> output, Counter counter) {
        this.output = output;
        this.numRecordsOut = counter;
    }

    @Override
    public void emitWatermark(Watermark mark) {
        this.output.emitWatermark(mark);
    }

    @Override
    public void emitWatermarkStatus(WatermarkStatus watermarkStatus) {
        this.output.emitWatermarkStatus(watermarkStatus);
    }

    @Override
    public void emitLatencyMarker(LatencyMarker latencyMarker) {
        this.output.emitLatencyMarker(latencyMarker);
    }

    @Override
    public void collect(StreamRecord<OUT> record) {
        this.numRecordsOut.inc();
        this.output.collect(record);
    }

    @Override
    public <X> void collect(OutputTag<X> outputTag, StreamRecord<X> record) {
        this.numRecordsOut.inc();
        this.output.collect(outputTag, record);
    }

    @Override
    public void close() {
        this.output.close();
    }
}

