/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.rank;

import java.util.Arrays;
import java.util.Comparator;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.runtime.generated.GeneratedRecordComparator;
import org.apache.flink.table.runtime.generated.RecordComparator;
import org.apache.flink.table.types.logical.LogicalType;

public final class ComparableRecordComparator
implements RecordComparator {
    private static final long serialVersionUID = 4386377835781068140L;
    private transient Comparator<RowData> comparator;
    private final GeneratedRecordComparator generatedRecordComparator;
    private final int[] compareKeyPositions;
    private final LogicalType[] compareKeyTypes;
    private final boolean[] compareOrders;
    private final boolean[] nullsIsLast;

    public ComparableRecordComparator(GeneratedRecordComparator generatedRecordComparator, int[] compareKeyPositions, LogicalType[] compareKeyTypes, boolean[] compareOrders, boolean[] nullsIsLast) {
        this.generatedRecordComparator = generatedRecordComparator;
        this.compareKeyPositions = compareKeyPositions;
        this.compareKeyTypes = compareKeyTypes;
        this.compareOrders = compareOrders;
        this.nullsIsLast = nullsIsLast;
    }

    public GeneratedRecordComparator getGeneratedRecordComparator() {
        return this.generatedRecordComparator;
    }

    @Override
    public int compare(RowData o1, RowData o2) {
        if (this.comparator == null) {
            this.comparator = (Comparator)this.generatedRecordComparator.newInstance(Thread.currentThread().getContextClassLoader());
        }
        return this.comparator.compare(o1, o2);
    }

    public int hashCode() {
        int result = Arrays.hashCode(this.compareKeyPositions);
        result = 31 * result + Arrays.hashCode(this.compareKeyTypes);
        result = 31 * result + Arrays.hashCode(this.compareOrders);
        result = 31 * result + Arrays.hashCode(this.nullsIsLast);
        return result;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ComparableRecordComparator that = (ComparableRecordComparator)o;
        return Arrays.equals(this.compareKeyPositions, that.compareKeyPositions) && Arrays.equals(this.compareKeyTypes, that.compareKeyTypes) && Arrays.equals(this.compareOrders, that.compareOrders) && Arrays.equals(this.nullsIsLast, that.nullsIsLast);
    }
}

