/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.format.orc;

import java.io.IOException;
import java.util.List;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.core.fs.Path;
import org.apache.flink.table.store.format.fs.HadoopReadOnlyFileSystem;
import org.apache.flink.table.store.shaded.org.apache.flink.orc.OrcFilters;
import org.apache.flink.table.store.shaded.org.apache.flink.orc.shim.OrcShim;
import org.apache.flink.table.store.shaded.org.apache.flink.orc.vector.HiveOrcBatchWrapper;
import org.apache.flink.table.store.shaded.org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.flink.table.store.shaded.org.apache.hadoop.hive.ql.io.sarg.SearchArgument;
import org.apache.flink.table.store.shaded.org.apache.hadoop.hive.ql.io.sarg.SearchArgumentFactory;
import org.apache.flink.table.store.shaded.org.apache.orc.OrcConf;
import org.apache.flink.table.store.shaded.org.apache.orc.OrcFile;
import org.apache.flink.table.store.shaded.org.apache.orc.Reader;
import org.apache.flink.table.store.shaded.org.apache.orc.RecordReader;
import org.apache.flink.table.store.shaded.org.apache.orc.StripeInformation;
import org.apache.flink.table.store.shaded.org.apache.orc.TypeDescription;
import org.apache.hadoop.conf.Configuration;

public class OrcShimImpl
implements OrcShim<VectorizedRowBatch> {
    private static final long serialVersionUID = 1L;

    @Override
    public RecordReader createRecordReader(Configuration conf, TypeDescription schema, int[] selectedFields, List<OrcFilters.Predicate> conjunctPredicates, Path path, long splitStart, long splitLength) throws IOException {
        Reader orcReader = OrcShimImpl.createReader(conf, path);
        Tuple2<Long, Long> offsetAndLength = OrcShimImpl.getOffsetAndLengthForSplit(splitStart, splitLength, orcReader.getStripes());
        Reader.Options options = new Reader.Options().schema(schema).range((Long)offsetAndLength.f0, (Long)offsetAndLength.f1).useZeroCopy(OrcConf.USE_ZEROCOPY.getBoolean(conf)).skipCorruptRecords(OrcConf.SKIP_CORRUPT_DATA.getBoolean(conf)).tolerateMissingSchema(OrcConf.TOLERATE_MISSING_SCHEMA.getBoolean(conf));
        if (!conjunctPredicates.isEmpty()) {
            SearchArgument.Builder b = SearchArgumentFactory.newBuilder();
            b = b.startAnd();
            for (OrcFilters.Predicate predicate : conjunctPredicates) {
                predicate.add(b);
            }
            b = b.end();
            options.searchArgument(b.build(), new String[0]);
        }
        options.include(OrcShimImpl.computeProjectionMask(schema, selectedFields));
        RecordReader orcRowsReader = orcReader.rows(options);
        schema.getId();
        return orcRowsReader;
    }

    public HiveOrcBatchWrapper createBatchWrapper(TypeDescription schema, int batchSize) {
        return new HiveOrcBatchWrapper(schema.createRowBatch(batchSize));
    }

    @Override
    public boolean nextBatch(RecordReader reader, VectorizedRowBatch rowBatch) throws IOException {
        return reader.nextBatch(rowBatch);
    }

    private static Tuple2<Long, Long> getOffsetAndLengthForSplit(long splitStart, long splitLength, List<StripeInformation> stripes) {
        long splitEnd = splitStart + splitLength;
        long readStart = Long.MAX_VALUE;
        long readEnd = Long.MIN_VALUE;
        for (StripeInformation s : stripes) {
            if (splitStart > s.getOffset() || s.getOffset() >= splitEnd) continue;
            readStart = Math.min(readStart, s.getOffset());
            readEnd = Math.max(readEnd, s.getOffset() + s.getLength());
        }
        if (readStart < Long.MAX_VALUE) {
            return Tuple2.of(readStart, readEnd - readStart);
        }
        return Tuple2.of(0L, 0L);
    }

    private static boolean[] computeProjectionMask(TypeDescription schema, int[] selectedFields) {
        boolean[] projectionMask = new boolean[schema.getMaximumId() + 1];
        for (int inIdx : selectedFields) {
            TypeDescription fieldSchema = schema.getChildren().get(inIdx);
            for (int i = fieldSchema.getId(); i <= fieldSchema.getMaximumId(); ++i) {
                projectionMask[i] = true;
            }
        }
        return projectionMask;
    }

    public static Reader createReader(Configuration conf, Path path) throws IOException {
        org.apache.hadoop.fs.Path hPath = new org.apache.hadoop.fs.Path(path.toUri());
        OrcFile.ReaderOptions readerOptions = OrcFile.readerOptions(conf);
        readerOptions.filesystem(new HadoopReadOnlyFileSystem(path.getFileSystem()));
        return OrcFile.createReader(hPath, readerOptions);
    }
}

