/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.spark;

import java.util.HashSet;
import java.util.Set;
import org.apache.flink.table.store.spark.SparkScanBuilder;
import org.apache.flink.table.store.spark.SparkTypeUtils;
import org.apache.flink.table.store.table.FileStoreTable;
import org.apache.spark.sql.connector.catalog.SupportsRead;
import org.apache.spark.sql.connector.catalog.Table;
import org.apache.spark.sql.connector.catalog.TableCapability;
import org.apache.spark.sql.connector.expressions.FieldReference;
import org.apache.spark.sql.connector.expressions.IdentityTransform;
import org.apache.spark.sql.connector.expressions.Transform;
import org.apache.spark.sql.connector.read.ScanBuilder;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.util.CaseInsensitiveStringMap;

public class SparkTable
implements Table,
SupportsRead {
    private final FileStoreTable table;

    public SparkTable(FileStoreTable table) {
        this.table = table;
    }

    public ScanBuilder newScanBuilder(CaseInsensitiveStringMap options) {
        return new SparkScanBuilder(this.table);
    }

    public String name() {
        return this.table.location().getName();
    }

    public StructType schema() {
        return SparkTypeUtils.fromFlinkRowType(this.table.schema().logicalRowType());
    }

    public Set<TableCapability> capabilities() {
        HashSet<TableCapability> capabilities = new HashSet<TableCapability>();
        capabilities.add(TableCapability.BATCH_READ);
        return capabilities;
    }

    public Transform[] partitioning() {
        return (Transform[])this.table.schema().partitionKeys().stream().map(FieldReference::apply).map(IdentityTransform::apply).toArray(Transform[]::new);
    }
}

