/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.partitioned;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collections;
import java.util.Set;
import org.apache.geode.DataSerializer;
import org.apache.geode.cache.CacheException;
import org.apache.geode.distributed.internal.ClusterDistributionManager;
import org.apache.geode.distributed.internal.DirectReplyProcessor;
import org.apache.geode.distributed.internal.DistributionManager;
import org.apache.geode.distributed.internal.DistributionMessage;
import org.apache.geode.distributed.internal.DistributionStats;
import org.apache.geode.distributed.internal.InternalDistributedSystem;
import org.apache.geode.distributed.internal.ReplyMessage;
import org.apache.geode.distributed.internal.ReplyProcessor21;
import org.apache.geode.distributed.internal.ReplySender;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.Assert;
import org.apache.geode.internal.cache.ForceReattemptException;
import org.apache.geode.internal.cache.PartitionedRegion;
import org.apache.geode.internal.cache.PartitionedRegionDataStore;
import org.apache.geode.internal.cache.PrimaryBucketException;
import org.apache.geode.internal.cache.partitioned.PRLocallyDestroyedException;
import org.apache.geode.internal.cache.partitioned.PartitionMessage;
import org.apache.geode.internal.cache.partitioned.PartitionMessageWithDirectReply;
import org.apache.geode.internal.logging.log4j.LogMarker;
import org.apache.geode.internal.serialization.DeserializationContext;
import org.apache.geode.internal.serialization.SerializationContext;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.logging.log4j.Logger;

public class ContainsKeyValueMessage
extends PartitionMessageWithDirectReply {
    private static final Logger logger = LogService.getLogger();
    private boolean valueCheck;
    private Object key;
    private Integer bucketId;

    public ContainsKeyValueMessage() {
    }

    public ContainsKeyValueMessage(InternalDistributedMember recipient, int regionId, DirectReplyProcessor processor, Object key, Integer bucketId, boolean valueCheck) {
        super(recipient, regionId, processor);
        this.valueCheck = valueCheck;
        this.key = key;
        this.bucketId = bucketId;
    }

    public static ContainsKeyValueResponse send(InternalDistributedMember recipient, PartitionedRegion r, Object key, Integer bucketId, boolean valueCheck) throws ForceReattemptException {
        Assert.assertTrue(recipient != null, "PRDistribuedContainsKeyValueMessage NULL reply message");
        ContainsKeyValueResponse p = new ContainsKeyValueResponse(r.getSystem(), Collections.singleton(recipient), key);
        ContainsKeyValueMessage m = new ContainsKeyValueMessage(recipient, r.getPRId(), p, key, bucketId, valueCheck);
        m.setTransactionDistributed(r.getCache().getTxManager().isDistributed());
        Set<InternalDistributedMember> failures = r.getDistributionManager().putOutgoing(m);
        if (failures != null && failures.size() > 0) {
            throw new ForceReattemptException(String.format("Failed sending < %s >", m));
        }
        return p;
    }

    @Override
    public boolean isSevereAlertCompatible() {
        return true;
    }

    @Override
    protected boolean operateOnPartitionedRegion(ClusterDistributionManager dm, PartitionedRegion r, long startTime) throws CacheException, ForceReattemptException {
        boolean replyVal;
        PartitionedRegionDataStore ds = r.getDataStore();
        if (ds != null) {
            try {
                if (this.valueCheck) {
                    replyVal = ds.containsValueForKeyLocally(this.bucketId, this.key);
                }
                replyVal = ds.containsKeyLocally(this.bucketId, this.key);
            }
            catch (PRLocallyDestroyedException pde) {
                throw new ForceReattemptException("Enountered PRLocallyDestroyedException", pde);
            }
        } else {
            logger.fatal("Partitioned Region <> is not configured to store data", (Object)r.getFullPath());
            ForceReattemptException fre = new ForceReattemptException(String.format("Partitioned Region %s on %s is not configured to store data", r.getFullPath(), dm.getId()));
            fre.setHash(this.key.hashCode());
            throw fre;
        }
        r.getPrStats().endPartitionMessagesProcessing(startTime);
        ContainsKeyValueReplyMessage.send(this.getSender(), this.getProcessorId(), this.getReplySender(dm), replyVal);
        return false;
    }

    @Override
    protected void appendFields(StringBuilder buff) {
        super.appendFields(buff);
        buff.append("; valueCheck=").append(this.valueCheck).append("; key=").append(this.key).append("; bucketId=").append(this.bucketId);
    }

    public int getDSFID() {
        return 43;
    }

    @Override
    public void fromData(DataInput in, DeserializationContext context) throws IOException, ClassNotFoundException {
        super.fromData(in, context);
        this.key = DataSerializer.readObject(in);
        this.valueCheck = in.readBoolean();
        this.bucketId = in.readInt();
    }

    @Override
    public void toData(DataOutput out, SerializationContext context) throws IOException {
        super.toData(out, context);
        DataSerializer.writeObject(this.key, out);
        out.writeBoolean(this.valueCheck);
        out.writeInt(this.bucketId);
    }

    public static class ContainsKeyValueResponse
    extends PartitionMessage.PartitionResponse {
        private volatile boolean returnValue;
        private volatile boolean returnValueReceived;
        final Object key;

        public ContainsKeyValueResponse(InternalDistributedSystem ds, Set recipients, Object key) {
            super(ds, recipients, false);
            this.key = key;
        }

        @Override
        public void process(DistributionMessage msg) {
            try {
                if (msg instanceof ContainsKeyValueReplyMessage) {
                    ContainsKeyValueReplyMessage reply = (ContainsKeyValueReplyMessage)msg;
                    this.returnValue = reply.doesItContainKeyValue();
                    this.returnValueReceived = true;
                    if (logger.isTraceEnabled(LogMarker.DM_VERBOSE)) {
                        logger.trace(LogMarker.DM_VERBOSE, "ContainsKeyValueResponse return value is {}", (Object)this.returnValue);
                    }
                }
            }
            finally {
                super.process(msg);
            }
        }

        public boolean waitForContainsResult() throws PrimaryBucketException, ForceReattemptException {
            try {
                this.waitForCacheException();
            }
            catch (ForceReattemptException rce) {
                rce.checkKey(this.key);
                throw rce;
            }
            catch (CacheException ce) {
                logger.debug("ContainsKeyValueResponse got remote CacheException; forcing reattempt. {}", (Object)ce.getMessage(), (Object)ce);
                throw new ForceReattemptException("ContainsKeyValueResponse got remote CacheException; forcing reattempt.", ce);
            }
            if (!this.returnValueReceived) {
                throw new ForceReattemptException("no return value received");
            }
            return this.returnValue;
        }
    }

    public static class ContainsKeyValueReplyMessage
    extends ReplyMessage {
        private boolean containsKeyValue;

        public ContainsKeyValueReplyMessage() {
        }

        private ContainsKeyValueReplyMessage(int processorId, boolean containsKeyValue) {
            this.processorId = processorId;
            this.containsKeyValue = containsKeyValue;
        }

        public static void send(InternalDistributedMember recipient, int processorId, ReplySender replySender, boolean containsKeyValue) {
            Assert.assertTrue(recipient != null, "ContainsKeyValueReplyMessage NULL reply message");
            ContainsKeyValueReplyMessage m = new ContainsKeyValueReplyMessage(processorId, containsKeyValue);
            m.setRecipient(recipient);
            replySender.putOutgoing(m);
        }

        @Override
        public void process(DistributionManager dm, ReplyProcessor21 processor) {
            long startTime = this.getTimestamp();
            if (processor == null) {
                if (logger.isTraceEnabled(LogMarker.DM_VERBOSE)) {
                    logger.trace(LogMarker.DM_VERBOSE, "ContainsKeyValueReplyMessage processor not found");
                }
                return;
            }
            processor.process(this);
            if (logger.isTraceEnabled(LogMarker.DM_VERBOSE)) {
                logger.trace(LogMarker.DM_VERBOSE, "{} Processed {}", (Object)processor, (Object)this);
            }
            dm.getStats().incReplyMessageTime(DistributionStats.getStatTime() - startTime);
        }

        @Override
        public int getDSFID() {
            return 64;
        }

        @Override
        public void fromData(DataInput in, DeserializationContext context) throws IOException, ClassNotFoundException {
            super.fromData(in, context);
            this.containsKeyValue = in.readBoolean();
        }

        @Override
        public void toData(DataOutput out, SerializationContext context) throws IOException {
            super.toData(out, context);
            out.writeBoolean(this.containsKeyValue);
        }

        @Override
        public String toString() {
            return "ContainsKeyValueReplyMessage processorid=" + this.processorId + " returning " + this.doesItContainKeyValue();
        }

        public boolean doesItContainKeyValue() {
            return this.containsKeyValue;
        }
    }
}

