/*
 * Decompiled with CFR 0.152.
 */
package org.apache.guacamole.auth.ban;

import org.apache.guacamole.GuacamoleException;
import org.apache.guacamole.auth.ban.status.AuthenticationFailureTracker;
import org.apache.guacamole.auth.ban.status.InMemoryAuthenticationFailureTracker;
import org.apache.guacamole.auth.ban.status.NullAuthenticationFailureTracker;
import org.apache.guacamole.environment.LocalEnvironment;
import org.apache.guacamole.net.auth.credentials.GuacamoleInsufficientCredentialsException;
import org.apache.guacamole.net.event.AuthenticationFailureEvent;
import org.apache.guacamole.net.event.AuthenticationRequestReceivedEvent;
import org.apache.guacamole.net.event.AuthenticationSuccessEvent;
import org.apache.guacamole.net.event.listener.Listener;
import org.apache.guacamole.properties.GuacamoleProperty;
import org.apache.guacamole.properties.IntegerGuacamoleProperty;
import org.apache.guacamole.properties.LongGuacamoleProperty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BanningAuthenticationListener
implements Listener {
    private static final Logger logger = LoggerFactory.getLogger(BanningAuthenticationListener.class);
    private static final IntegerGuacamoleProperty MAX_ATTEMPTS = new IntegerGuacamoleProperty(){

        public String getName() {
            return "ban-max-invalid-attempts";
        }
    };
    private static final IntegerGuacamoleProperty IP_BAN_DURATION = new IntegerGuacamoleProperty(){

        public String getName() {
            return "ban-address-duration";
        }
    };
    private static final LongGuacamoleProperty MAX_ADDRESSES = new LongGuacamoleProperty(){

        public String getName() {
            return "ban-max-addresses";
        }
    };
    private static final int DEFAULT_MAX_ATTEMPTS = 5;
    private static final int DEFAULT_IP_BAN_DURATION = 300;
    private static final long DEFAULT_MAX_ADDRESSES = 0xA00000L;
    private final AuthenticationFailureTracker tracker;

    public BanningAuthenticationListener() throws GuacamoleException {
        LocalEnvironment environment = LocalEnvironment.getInstance();
        int maxAttempts = (Integer)environment.getProperty((GuacamoleProperty)MAX_ATTEMPTS, (Object)5);
        int banDuration = (Integer)environment.getProperty((GuacamoleProperty)IP_BAN_DURATION, (Object)300);
        long maxAddresses = (Long)environment.getProperty((GuacamoleProperty)MAX_ADDRESSES, (Object)0xA00000L);
        if (maxAttempts <= 0) {
            this.tracker = new NullAuthenticationFailureTracker();
            logger.info("Maximum failed authentication attempts has been set to {}. Automatic banning of brute-force authentication attempts will be disabled.", (Object)maxAttempts);
        } else if (banDuration <= 0) {
            this.tracker = new NullAuthenticationFailureTracker();
            logger.info("Ban duration for addresses that repeatedly fail authentication has been set to {}. Automatic banning of brute-force authentication attempts will be disabled.", (Object)banDuration);
        } else if (maxAddresses <= 0L) {
            this.tracker = new NullAuthenticationFailureTracker();
            logger.info("Maximum number of tracked addresses has been set to {}. Automatic banning of brute-force authentication attempts will be disabled.", (Object)maxAddresses);
        } else {
            this.tracker = new InMemoryAuthenticationFailureTracker(maxAttempts, banDuration, maxAddresses);
            logger.info("Addresses will be automatically banned for {} seconds after {} failed authentication attempts. Up to {} unique addresses will be tracked/banned at any given time.", new Object[]{banDuration, maxAttempts, maxAddresses});
        }
    }

    public void handleEvent(Object event) throws GuacamoleException {
        if (event instanceof AuthenticationRequestReceivedEvent) {
            AuthenticationRequestReceivedEvent request = (AuthenticationRequestReceivedEvent)event;
            this.tracker.notifyAuthenticationRequestReceived(request.getCredentials());
        } else if (event instanceof AuthenticationFailureEvent) {
            AuthenticationFailureEvent failure = (AuthenticationFailureEvent)event;
            if (failure.getFailure() instanceof GuacamoleInsufficientCredentialsException) {
                this.tracker.notifyAuthenticationRequestReceived(failure.getCredentials());
                return;
            }
            this.tracker.notifyAuthenticationFailed(failure.getCredentials());
        } else if (event instanceof AuthenticationSuccessEvent) {
            AuthenticationSuccessEvent success = (AuthenticationSuccessEvent)event;
            this.tracker.notifyAuthenticationSuccess(success.getCredentials());
        }
    }
}

