/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.manager.zk;

import org.apache.helix.HelixException;
import org.apache.helix.msdcommon.datamodel.MetadataStoreRoutingData;
import org.apache.helix.msdcommon.exception.InvalidRoutingDataException;
import org.apache.helix.zookeeper.api.client.HelixZkClient;
import org.apache.helix.zookeeper.api.client.RealmAwareZkClient;
import org.apache.helix.zookeeper.datamodel.serializer.ZNRecordSerializer;
import org.apache.helix.zookeeper.impl.client.FederatedZkClient;
import org.apache.helix.zookeeper.impl.factory.SharedZkClientFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class GenericZkHelixApiBuilder<B extends GenericZkHelixApiBuilder<B>> {
    private static final Logger LOG = LoggerFactory.getLogger((String)GenericZkHelixApiBuilder.class.getName());
    protected String _zkAddress;
    protected RealmAwareZkClient.RealmMode _realmMode;
    protected RealmAwareZkClient.RealmAwareZkConnectionConfig _realmAwareZkConnectionConfig;
    protected RealmAwareZkClient.RealmAwareZkClientConfig _realmAwareZkClientConfig;

    public B setZkAddress(String zkAddress) {
        this._zkAddress = zkAddress;
        return this.self();
    }

    public B setRealmMode(RealmAwareZkClient.RealmMode realmMode) {
        this._realmMode = realmMode;
        return this.self();
    }

    public B setRealmAwareZkConnectionConfig(RealmAwareZkClient.RealmAwareZkConnectionConfig realmAwareZkConnectionConfig) {
        this._realmAwareZkConnectionConfig = realmAwareZkConnectionConfig;
        return this.self();
    }

    public B setRealmAwareZkClientConfig(RealmAwareZkClient.RealmAwareZkClientConfig realmAwareZkClientConfig) {
        this._realmAwareZkClientConfig = realmAwareZkClientConfig;
        return this.self();
    }

    protected void validate() {
        boolean isZkAddressSet;
        this.initializeConfigsIfNull();
        boolean bl = isZkAddressSet = this._zkAddress != null && !this._zkAddress.isEmpty();
        if (!isZkAddressSet && this._realmAwareZkConnectionConfig.getZkRealmShardingKey() != null && !this._realmAwareZkConnectionConfig.getZkRealmShardingKey().isEmpty()) {
            if (this._realmMode == RealmAwareZkClient.RealmMode.SINGLE_REALM) {
                try {
                    this._zkAddress = this.resolveZkAddressWithShardingKey(this._realmAwareZkConnectionConfig);
                    isZkAddressSet = true;
                }
                catch (InvalidRoutingDataException e) {
                    LOG.warn("GenericZkHelixApiBuilder: ZkAddress is not set and failed to resolve ZkAddress with ZK path sharding key!", (Throwable)e);
                }
            } else if (this._realmMode == RealmAwareZkClient.RealmMode.MULTI_REALM) {
                throw new HelixException("GenericZkHelixApiBuilder: Cannot have a ZK path sharding key in ConnectionConfig on multi-realm mode! Multi-realm accesses multiple sharding keys.");
            }
        }
        if (this._realmMode == RealmAwareZkClient.RealmMode.SINGLE_REALM && !isZkAddressSet) {
            throw new HelixException("GenericZkHelixApiBuilder: RealmMode cannot be single-realm without a valid ZkAddress set!");
        }
        if (this._realmMode == RealmAwareZkClient.RealmMode.MULTI_REALM && isZkAddressSet) {
            throw new HelixException("GenericZkHelixApiBuilder: ZkAddress cannot be set on multi-realm mode!");
        }
        if (this._realmMode == null) {
            this._realmMode = isZkAddressSet ? RealmAwareZkClient.RealmMode.SINGLE_REALM : RealmAwareZkClient.RealmMode.MULTI_REALM;
        }
    }

    protected void initializeConfigsIfNull() {
        if (this._realmAwareZkConnectionConfig == null) {
            this._realmAwareZkConnectionConfig = new RealmAwareZkClient.RealmAwareZkConnectionConfig.Builder().build();
        }
        if (this._realmAwareZkClientConfig == null) {
            this._realmAwareZkClientConfig = new RealmAwareZkClient.RealmAwareZkClientConfig().setZkSerializer(new ZNRecordSerializer());
        }
    }

    protected RealmAwareZkClient createZkClient(RealmAwareZkClient.RealmMode realmMode, RealmAwareZkClient.RealmAwareZkConnectionConfig connectionConfig, RealmAwareZkClient.RealmAwareZkClientConfig clientConfig, String zkAddress) {
        switch (realmMode) {
            case MULTI_REALM: {
                try {
                    return new FederatedZkClient(connectionConfig, clientConfig.setZkSerializer(new ZNRecordSerializer()));
                }
                catch (IllegalStateException | InvalidRoutingDataException e) {
                    throw new HelixException("GenericZkHelixApiBuilder: Failed to create FederatedZkClient!", e);
                }
            }
            case SINGLE_REALM: {
                return SharedZkClientFactory.getInstance().buildZkClient(new HelixZkClient.ZkConnectionConfig(zkAddress).setSessionTimeout(connectionConfig.getSessionTimeout()), clientConfig.createHelixZkClientConfig().setZkSerializer(new ZNRecordSerializer()));
            }
        }
        throw new HelixException("GenericZkHelixApiBuilder: Invalid RealmMode given: " + (Object)((Object)realmMode));
    }

    final B self() {
        return (B)this;
    }

    private String resolveZkAddressWithShardingKey(RealmAwareZkClient.RealmAwareZkConnectionConfig connectionConfig) throws InvalidRoutingDataException {
        MetadataStoreRoutingData routingData = RealmAwareZkClient.getMetadataStoreRoutingData(connectionConfig);
        return routingData.getMetadataStoreRealm(connectionConfig.getZkRealmShardingKey());
    }
}

