ace.define("ace/mode/perl_highlight_rules",["require","exports","module","ace/lib/oop","ace/mode/text_highlight_rules"],function(a,u,f){"use strict";var m=a("../lib/oop"),d=a("./text_highlight_rules").TextHighlightRules,s=function(){var e=this.createKeywordMapper({keyword:"base|constant|continue|else|elsif|for|foreach|format|goto|if|last|local|my|next|no|package|parent|redo|require|scalar|sub|unless|until|while|use|vars","constant.language":"ARGV|ENV|INC|SIG","support.function":"getprotobynumber|getprotobyname|getservbyname|gethostbyaddr|gethostbyname|getservbyport|getnetbyaddr|getnetbyname|getsockname|getpeername|setpriority|getprotoent|setprotoent|getpriority|endprotoent|getservent|setservent|endservent|sethostent|socketpair|getsockopt|gethostent|endhostent|setsockopt|setnetent|quotemeta|localtime|prototype|getnetent|endnetent|rewinddir|wantarray|getpwuid|closedir|getlogin|readlink|endgrent|getgrgid|getgrnam|shmwrite|shutdown|readline|endpwent|setgrent|readpipe|formline|truncate|dbmclose|syswrite|setpwent|getpwnam|getgrent|getpwent|ucfirst|sysread|setpgrp|shmread|sysseek|sysopen|telldir|defined|opendir|connect|lcfirst|getppid|binmode|syscall|sprintf|getpgrp|readdir|seekdir|waitpid|reverse|unshift|symlink|dbmopen|semget|msgrcv|rename|listen|chroot|msgsnd|shmctl|accept|unpack|exists|fileno|shmget|system|unlink|printf|gmtime|msgctl|semctl|values|rindex|substr|splice|length|msgget|select|socket|return|caller|delete|alarm|ioctl|index|undef|lstat|times|srand|chown|fcntl|close|write|umask|rmdir|study|sleep|chomp|untie|print|utime|mkdir|atan2|split|crypt|flock|chmod|BEGIN|bless|chdir|semop|shift|reset|link|stat|chop|grep|fork|dump|join|open|tell|pipe|exit|glob|warn|each|bind|sort|pack|eval|push|keys|getc|kill|seek|sqrt|send|wait|rand|tied|read|time|exec|recv|eof|chr|int|ord|exp|pos|pop|sin|log|abs|oct|hex|tie|cos|vec|END|ref|map|die|uc|lc|do"},"identifier");this.$rules={start:[{token:"comment.doc",regex:"^=(?:begin|item)\\b",next:"block_comment"},{token:"string.regexp",regex:"[/](?:(?:\\[(?:\\\\]|[^\\]])+\\])|(?:\\\\/|[^\\]/]))*[/]\\w*\\s*(?=[).,;]|$)"},{token:"string",regex:'["](?:(?:\\\\.)|(?:[^"\\\\]))*?["]'},{token:"string",regex:'["].*\\\\$',next:"qqstring"},{token:"string",regex:"['](?:(?:\\\\.)|(?:[^'\\\\]))*?[']"},{token:"string",regex:"['].*\\\\$",next:"qstring"},{token:"constant.numeric",regex:"0x[0-9a-fA-F]+\\b"},{token:"constant.numeric",regex:"[+-]?\\d+(?:(?:\\.\\d*)?(?:[eE][+-]?\\d+)?)?\\b"},{token:e,regex:"[a-zA-Z_$][a-zA-Z0-9_$]*\\b"},{token:"keyword.operator",regex:"%#|\\$#|\\.\\.\\.|\\|\\|=|>>=|<<=|<=>|&&=|=>|!~|\\^=|&=|\\|=|\\.=|x=|%=|\\/=|\\*=|\\-=|\\+=|=~|\\*\\*|\\-\\-|\\.\\.|\\|\\||&&|\\+\\+|\\->|!=|==|>=|<=|>>|<<|,|=|\\?\\:|\\^|\\||x|%|\\/|\\*|<|&|\\\\|~|!|>|\\.|\\-|\\+|\\-C|\\-b|\\-S|\\-u|\\-t|\\-p|\\-l|\\-d|\\-f|\\-g|\\-s|\\-z|\\-k|\\-e|\\-O|\\-T|\\-B|\\-M|\\-A|\\-X|\\-W|\\-c|\\-R|\\-o|\\-x|\\-w|\\-r|\\b(?:and|cmp|eq|ge|gt|le|lt|ne|not|or|xor)"},{token:"comment",regex:"#.*$"},{token:"lparen",regex:"[[({]"},{token:"rparen",regex:"[\\])}]"},{token:"text",regex:"\\s+"}],qqstring:[{token:"string",regex:'(?:(?:\\\\.)|(?:[^"\\\\]))*?"',next:"start"},{token:"string",regex:".+"}],qstring:[{token:"string",regex:"(?:(?:\\\\.)|(?:[^'\\\\]))*?'",next:"start"},{token:"string",regex:".+"}],block_comment:[{token:"comment.doc",regex:"^=cut\\b",next:"start"},{defaultToken:"comment.doc"}]}};m.inherits(s,d),u.PerlHighlightRules=s}),ace.define("ace/mode/matching_brace_outdent",["require","exports","module","ace/range"],function(a,u,f){"use strict";var m=a("../range").Range,d=function(){};(function(){this.checkOutdent=function(s,l){return!!/^\s+$/.test(s)&&/^\s*\}/.test(l)},this.autoOutdent=function(s,l){var n=s.getLine(l).match(/^(\s*\})/);if(!n)return 0;var e=n[1].length,r=s.findMatchingBracket({row:l,column:e});if(!r||r.row==l)return 0;var o=this.$getIndent(s.getLine(r.row));s.replace(new m(l,0,l,e-1),o)},this.$getIndent=function(s){return s.match(/^\s*/)[0]}}).call(d.prototype),u.MatchingBraceOutdent=d}),ace.define("ace/mode/folding/cstyle",["require","exports","module","ace/lib/oop","ace/range","ace/mode/folding/fold_mode"],function(a,u,f){"use strict";var m=a("../../lib/oop"),d=a("../../range").Range,s=a("./fold_mode").FoldMode,l=u.FoldMode=function(t){t&&(this.foldingStartMarker=new RegExp(this.foldingStartMarker.source.replace(/\|[^|]*?$/,"|"+t.start)),this.foldingStopMarker=new RegExp(this.foldingStopMarker.source.replace(/\|[^|]*?$/,"|"+t.end)))};m.inherits(l,s),function(){this.foldingStartMarker=/([\{\[\(])[^\}\]\)]*$|^\s*(\/\*)/,this.foldingStopMarker=/^[^\[\{\(]*([\}\]\)])|^[\s\*]*(\*\/)/,this.singleLineBlockCommentRe=/^\s*(\/\*).*\*\/\s*$/,this.tripleStarBlockCommentRe=/^\s*(\/\*\*\*).*\*\/\s*$/,this.startRegionRe=/^\s*(\/\*|\/\/)#?region\b/,this._getFoldWidgetBase=this.getFoldWidget,this.getFoldWidget=function(t,n,e){var r=t.getLine(e);if(this.singleLineBlockCommentRe.test(r)&&!this.startRegionRe.test(r)&&!this.tripleStarBlockCommentRe.test(r))return"";var o=this._getFoldWidgetBase(t,n,e);return!o&&this.startRegionRe.test(r)?"start":o},this.getFoldWidgetRange=function(t,n,e,r){var i,o=t.getLine(e);if(this.startRegionRe.test(o))return this.getCommentRegionBlock(t,o,e);if(i=o.match(this.foldingStartMarker)){var g=i.index;if(i[1])return this.openingBracketBlock(t,i[1],e,g);var c=t.getCommentFoldRange(e,g+i[0].length,1);return c&&!c.isMultiLine()&&(r?c=this.getSectionRange(t,e):"all"!=n&&(c=null)),c}return"markbegin"!==n&&(i=o.match(this.foldingStopMarker))?(g=i.index+i[0].length,i[1]?this.closingBracketBlock(t,i[1],e,g):t.getCommentFoldRange(e,g,-1)):void 0},this.getSectionRange=function(t,n){for(var e=t.getLine(n),r=e.search(/\S/),o=n,g=e.length,c=n+=1,i=t.getLength();++n<i;){var h=(e=t.getLine(n)).search(/\S/);if(-1!==h){if(r>h)break;var p=this.getFoldWidgetRange(t,"all",n);if(p){if(p.start.row<=o)break;if(p.isMultiLine())n=p.end.row;else if(r==h)break}c=n}}return new d(o,g,c,t.getLine(c).length)},this.getCommentRegionBlock=function(t,n,e){for(var r=n.search(/\s*$/),o=t.getLength(),g=e,c=/^\s*(?:\/\*|\/\/|--)#?(end)?region\b/,i=1;++e<o;){n=t.getLine(e);var h=c.exec(n);if(h&&(h[1]?i--:i++,!i))break}if(e>g)return new d(g,r,e,n.length)}}.call(l.prototype)}),ace.define("ace/mode/perl",["require","exports","module","ace/lib/oop","ace/mode/text","ace/mode/perl_highlight_rules","ace/mode/matching_brace_outdent","ace/mode/folding/cstyle"],function(a,u,f){"use strict";var m=a("../lib/oop"),d=a("./text").Mode,s=a("./perl_highlight_rules").PerlHighlightRules,l=a("./matching_brace_outdent").MatchingBraceOutdent,t=a("./folding/cstyle").FoldMode,n=function(){this.HighlightRules=s,this.$outdent=new l,this.foldingRules=new t({start:"^=(begin|item)\\b",end:"^=(cut)\\b"}),this.$behaviour=this.$defaultBehaviour};m.inherits(n,d),function(){this.lineCommentStart="#",this.blockComment=[{start:"=begin",end:"=cut",lineStartOnly:!0},{start:"=item",end:"=cut",lineStartOnly:!0}],this.getNextLineIndent=function(e,r,o){var g=this.$getIndent(r),i=this.getTokenizer().getLineTokens(r,e).tokens;return i.length&&"comment"==i[i.length-1].type||"start"==e&&r.match(/^.*[\{\(\[:]\s*$/)&&(g+=o),g},this.checkOutdent=function(e,r,o){return this.$outdent.checkOutdent(r,o)},this.autoOutdent=function(e,r,o){this.$outdent.autoOutdent(r,o)},this.$id="ace/mode/perl",this.snippetFileId="ace/snippets/perl"}.call(n.prototype),u.Mode=n}),ace.require(["ace/mode/perl"],function(a){"object"==typeof module&&"object"==typeof exports&&module&&(module.exports=a)});