ace.define("ace/snippets",["require","exports","module","ace/lib/dom","ace/lib/oop","ace/lib/event_emitter","ace/lib/lang","ace/range","ace/range_list","ace/keyboard/hash_handler","ace/tokenizer","ace/clipboard","ace/editor"],function(T,b,D){"use strict";var U=T("./lib/dom"),V=T("./lib/oop"),z=T("./lib/event_emitter").EventEmitter,A=T("./lib/lang"),$=T("./range").Range,S=T("./range_list").RangeList,k=T("./keyboard/hash_handler").HashHandler,O=T("./tokenizer").Tokenizer,N=T("./clipboard"),C={CURRENT_WORD:function(n){return n.session.getTextRange(n.session.getWordRange())},SELECTION:function(n,e,t){var s=n.session.getTextRange();return t?s.replace(/\n\r?([ \t]*\S)/g,"\n"+t+"$1"):s},CURRENT_LINE:function(n){return n.session.getLine(n.getCursorPosition().row)},PREV_LINE:function(n){return n.session.getLine(n.getCursorPosition().row-1)},LINE_INDEX:function(n){return n.getCursorPosition().row},LINE_NUMBER:function(n){return n.getCursorPosition().row+1},SOFT_TABS:function(n){return n.session.getUseSoftTabs()?"YES":"NO"},TAB_SIZE:function(n){return n.session.getTabSize()},CLIPBOARD:function(n){return N.getText&&N.getText()},FILENAME:function(n){return/[^/\\]*$/.exec(this.FILEPATH(n))[0]},FILENAME_BASE:function(n){return/[^/\\]*$/.exec(this.FILEPATH(n))[0].replace(/\.[^.]*$/,"")},DIRECTORY:function(n){return this.FILEPATH(n).replace(/[^/\\]*$/,"")},FILEPATH:function(n){return"/not implemented.txt"},WORKSPACE_NAME:function(){return"Unknown"},FULLNAME:function(){return"Unknown"},BLOCK_COMMENT_START:function(n){var e=n.session.$mode||{};return e.blockComment&&e.blockComment.start||""},BLOCK_COMMENT_END:function(n){var e=n.session.$mode||{};return e.blockComment&&e.blockComment.end||""},LINE_COMMENT:function(n){return(n.session.$mode||{}).lineCommentStart||""},CURRENT_YEAR:E.bind(null,{year:"numeric"}),CURRENT_YEAR_SHORT:E.bind(null,{year:"2-digit"}),CURRENT_MONTH:E.bind(null,{month:"numeric"}),CURRENT_MONTH_NAME:E.bind(null,{month:"long"}),CURRENT_MONTH_NAME_SHORT:E.bind(null,{month:"short"}),CURRENT_DATE:E.bind(null,{day:"2-digit"}),CURRENT_DAY_NAME:E.bind(null,{weekday:"long"}),CURRENT_DAY_NAME_SHORT:E.bind(null,{weekday:"short"}),CURRENT_HOUR:E.bind(null,{hour:"2-digit",hour12:!1}),CURRENT_MINUTE:E.bind(null,{minute:"2-digit"}),CURRENT_SECOND:E.bind(null,{second:"2-digit"})};function E(n){var e=(new Date).toLocaleString("en-us",n);return 1==e.length?"0"+e:e}C.SELECTED_TEXT=C.SELECTION;var R=function(){this.snippetMap={},this.snippetNameMap={}};(function(){V.implement(this,z),this.getTokenizer=function(){return R.$tokenizer||this.createTokenizer()},this.createTokenizer=function(){function e(i){return i=i.substr(1),/^\d+$/.test(i)?[{tabstopId:parseInt(i,10)}]:[{text:i}]}function t(i){return"(?:[^\\\\"+i+"]|\\\\.)"}var s={regex:"/("+t("/")+"+)/",onMatch:function(i,c,o){var r=o[0];return r.fmtString=!0,r.guard=i.slice(1,-1),r.flag="",""},next:"formatString"};return R.$tokenizer=new O({start:[{regex:/\\./,onMatch:function(i,c,o){var r=i[1];return("}"==r&&o.length||-1!="`$\\".indexOf(r))&&(i=r),[i]}},{regex:/}/,onMatch:function(i,c,o){return[o.length?o.shift():i]}},{regex:/\$(?:\d+|\w+)/,onMatch:e},{regex:/\$\{[\dA-Z_a-z]+/,onMatch:function(i,c,o){var r=e(i.substr(1));return o.unshift(r[0]),r},next:"snippetVar"},{regex:/\n/,token:"newline",merge:!1}],snippetVar:[{regex:"\\|"+t("\\|")+"*\\|",onMatch:function(i,c,o){var r=i.slice(1,-1).replace(/\\[,|\\]|,/g,function(f){return 2==f.length?f[1]:"\0"}).split("\0").map(function(f){return{value:f}});return o[0].choices=r,[r[0]]},next:"start"},s,{regex:"([^:}\\\\]|\\\\.)*:?",token:"",next:"start"}],formatString:[{regex:/:/,onMatch:function(i,c,o){return o.length&&o[0].expectElse?(o[0].expectElse=!1,o[0].ifEnd={elseEnd:o[0]},[o[0].ifEnd]):":"}},{regex:/\\./,onMatch:function(i,c,o){var r=i[1];return"}"==r&&o.length||-1!="`$\\".indexOf(r)?i=r:"n"==r?i="\n":"t"==r?i="\t":-1!="ulULE".indexOf(r)&&(i={changeCase:r,local:r>"a"}),[i]}},{regex:"/\\w*}",onMatch:function(i,c,o){var r=o.shift();return r&&(r.flag=i.slice(1,-1)),this.next=r&&r.tabstopId?"start":"",[r||i]},next:"start"},{regex:/\$(?:\d+|\w+)/,onMatch:function(i,c,o){return[{text:i.slice(1)}]}},{regex:/\${\w+/,onMatch:function(i,c,o){var r={text:i.slice(2)};return o.unshift(r),[r]},next:"formatStringVar"},{regex:/\n/,token:"newline",merge:!1},{regex:/}/,onMatch:function(i,c,o){var r=o.shift();return this.next=r&&r.tabstopId?"start":"",[r||i]},next:"start"}],formatStringVar:[{regex:/:\/\w+}/,onMatch:function(i,c,o){return o[0].formatFunction=i.slice(2,-1),[o.shift()]},next:"formatString"},s,{regex:/:[\?\-+]?/,onMatch:function(i,c,o){"+"==i[1]&&(o[0].ifEnd=o[0]),"?"==i[1]&&(o[0].expectElse=!0)},next:"formatString"},{regex:"([^:}\\\\]|\\\\.)*:?",token:"",next:"formatString"}]})},this.tokenizeTmSnippet=function(e,t){return this.getTokenizer().getLineTokens(e,t).tokens.map(function(s){return s.value||s})},this.getVariableValue=function(e,t,s){if(/^\d+$/.test(t))return(this.variables.__||{})[t]||"";if(/^[A-Z]\d+$/.test(t))return(this.variables[t[0]+"__"]||{})[t.substr(1)]||"";if(t=t.replace(/^TM_/,""),!this.variables.hasOwnProperty(t))return"";var i=this.variables[t];return"function"==typeof i&&(i=this.variables[t](e,t,s)),null==i?"":i},this.variables=C,this.tmStrFormat=function(e,t,s){if(!t.fmt)return e;var c=t.guard;c=new RegExp(c,(t.flag||"").replace(/[^gim]/g,""));var o="string"==typeof t.fmt?this.tokenizeTmSnippet(t.fmt,"formatString"):t.fmt,r=this,f=e.replace(c,function(){var a=r.variables.__;r.variables.__=[].slice.call(arguments);for(var u=r.resolveVariables(o,s),_="E",m=0;m<u.length;m++){var d=u[m];if("object"==typeof d)if(u[m]="",d.changeCase&&d.local){var y=u[m+1];y&&"string"==typeof y&&(u[m]="u"==d.changeCase?y[0].toUpperCase():y[0].toLowerCase(),u[m+1]=y.substr(1))}else d.changeCase&&(_=d.changeCase);else"U"==_?u[m]=d.toUpperCase():"L"==_&&(u[m]=d.toLowerCase())}return r.variables.__=a,u.join("")});return f},this.tmFormatFunction=function(e,t,s){return"upcase"==t.formatFunction?e.toUpperCase():"downcase"==t.formatFunction?e.toLowerCase():e},this.resolveVariables=function(e,t){for(var s=[],i="",c=!0,o=0;o<e.length;o++){var r=e[o];if("string"!=typeof r){if(r){if(c=!1,r.fmtString){var f=e.indexOf(r,o+1);-1==f&&(f=e.length),r.fmt=e.slice(o+1,f),o=f}if(r.text){var a=this.getVariableValue(t,r.text,i)+"";r.fmtString&&(a=this.tmStrFormat(a,r,t)),r.formatFunction&&(a=this.tmFormatFunction(a,r,t)),a&&!r.ifEnd?(s.push(a),u(r)):!a&&r.ifEnd&&u(r.ifEnd)}else r.elseEnd?u(r.elseEnd):(null!=r.tabstopId||null!=r.changeCase)&&s.push(r)}}else s.push(r),"\n"==r?(c=!0,i=""):c&&(i=/^\t*/.exec(r)[0],c=/\S/.test(r))}function u(_){var m=e.indexOf(_,o+1);-1!=m&&(o=m)}return s};var n=function(e,t,s){var i=e.getCursorPosition(),c=e.session.getLine(i.row),o=e.session.getTabString(),r=c.match(/^\s*/)[0];i.column<r.length&&(r=r.slice(0,i.column)),t=t.replace(/\r/g,"");var f=this.tokenizeTmSnippet(t);f=(f=this.resolveVariables(f,e)).map(function(v){return"\n"==v?v+r:"string"==typeof v?v.replace(/\t/g,o):v});var a=[];f.forEach(function(v,M){if("object"==typeof v){var w=v.tabstopId,x=a[w];if(x||((x=a[w]=[]).index=w,x.value="",x.parents={}),-1===x.indexOf(v)){v.choices&&!x.choices&&(x.choices=v.choices),x.push(v);var F=f.indexOf(v,M+1);if(-1!==F){var H=f.slice(M+1,F);H.some(function(W){return"object"==typeof W})&&!x.value?x.value=H:H.length&&(!x.value||"string"!=typeof x.value)&&(x.value=H.join(""))}}}}),a.forEach(function(v){v.length=0});var u={};function _(v){for(var M=[],w=0;w<v.length;w++){var x=v[w];if("object"==typeof x){if(u[x.tabstopId])continue;x=M[v.lastIndexOf(x,w-1)]||{tabstopId:x.tabstopId}}M[w]=x}return M}for(var m=0;m<f.length;m++){var d=f[m];if("object"==typeof d){var y=d.tabstopId,I=a[y],K=f.indexOf(d,m+1);if(u[y]){u[y]===d&&(delete u[y],Object.keys(u).forEach(function(v){I.parents[v]=!0}));continue}u[y]=d;var L=I.value;"string"!=typeof L?L=_(L):d.fmt&&(L=this.tmStrFormat(L,d,e)),f.splice.apply(f,[m+1,Math.max(0,K-m)].concat(L,d)),-1===I.indexOf(d)&&I.push(d)}}var B=0,P=0,j="";return f.forEach(function(v){if("string"==typeof v){var M=v.split("\n");M.length>1?(P=M[M.length-1].length,B+=M.length-1):P+=v.length,j+=v}else v&&(v.start?v.end={row:B,column:P}:v.start={row:B,column:P})}),{text:j,tabstops:a,tokens:f}};this.getDisplayTextForSnippet=function(e,t){return n.call(this,e,t).text},this.insertSnippetForSelection=function(e,t,s){var i=n.call(this,e,t),c=e.getSelectionRange();s&&0===s.compareRange(c)&&(c=s);var o=e.session.replace(c,i.text);new h(e).addTabstops(i.tabstops,c.start,o,e.inVirtualSelectionMode&&e.selection.index)},this.insertSnippet=function(e,t,s){var i=this;if(e.inVirtualSelectionMode)return i.insertSnippetForSelection(e,t,s);e.forEachSelection(function(){i.insertSnippetForSelection(e,t,s)},null,{keepOrder:!0}),e.tabstopManager&&e.tabstopManager.tabNext()},this.$getScope=function(e){var t=e.session.$mode.$id||"";if("html"===(t=t.split("/").pop())||"php"===t){"php"===t&&!e.session.$mode.inlinePhp&&(t="html");var s=e.getCursorPosition(),i=e.session.getState(s.row);"object"==typeof i&&(i=i[0]),i.substring&&("js-"==i.substring(0,3)?t="javascript":"css-"==i.substring(0,4)?t="css":"php-"==i.substring(0,4)&&(t="php"))}return t},this.getActiveScopes=function(e){var t=this.$getScope(e),s=[t],i=this.snippetMap;return i[t]&&i[t].includeScopes&&s.push.apply(s,i[t].includeScopes),s.push("_"),s},this.expandWithTab=function(e,t){var s=this,i=e.forEachSelection(function(){return s.expandSnippetForSelection(e,t)},null,{keepOrder:!0});return i&&e.tabstopManager&&e.tabstopManager.tabNext(),i},this.expandSnippetForSelection=function(e,t){var f,s=e.getCursorPosition(),i=e.session.getLine(s.row),c=i.substring(0,s.column),o=i.substr(s.column),r=this.snippetMap;return this.getActiveScopes(e).some(function(a){var u=r[a];return u&&(f=this.findMatchingSnippet(u,c,o)),!!f},this),!!f&&(t&&t.dryRun||(e.session.doc.removeInLine(s.row,s.column-f.replaceBefore.length,s.column+f.replaceAfter.length),this.variables.M__=f.matchBefore,this.variables.T__=f.matchAfter,this.insertSnippetForSelection(e,f.content),this.variables.M__=this.variables.T__=null),!0)},this.findMatchingSnippet=function(e,t,s){for(var i=e.length;i--;){var c=e[i];if((!c.startRe||c.startRe.test(t))&&(!c.endRe||c.endRe.test(s))&&(c.startRe||c.endRe))return c.matchBefore=c.startRe?c.startRe.exec(t):[""],c.matchAfter=c.endRe?c.endRe.exec(s):[""],c.replaceBefore=c.triggerRe?c.triggerRe.exec(t)[0]:"",c.replaceAfter=c.endTriggerRe?c.endTriggerRe.exec(s)[0]:"",c}},this.snippetMap={},this.snippetNameMap={},this.register=function(e,t){var s=this.snippetMap,i=this.snippetNameMap,c=this;function o(a){return a&&!/^\^?\(.*\)\$?$|^\\b$/.test(a)&&(a="(?:"+a+")"),a||""}function r(a,u,_){return a=o(a),u=o(u),_?(a=u+a)&&"$"!=a[a.length-1]&&(a+="$"):(a+=u)&&"^"!=a[0]&&(a="^"+a),new RegExp(a)}function f(a){a.scope||(a.scope=t||"_"),s[t=a.scope]||(s[t]=[],i[t]={});var u=i[t];if(a.name){var _=u[a.name];_&&c.unregister(_),u[a.name]=a}s[t].push(a),a.prefix&&(a.tabTrigger=a.prefix),!a.content&&a.body&&(a.content=Array.isArray(a.body)?a.body.join("\n"):a.body),a.tabTrigger&&!a.trigger&&(!a.guard&&/^\w/.test(a.tabTrigger)&&(a.guard="\\b"),a.trigger=A.escapeRegExp(a.tabTrigger)),(a.trigger||a.guard||a.endTrigger||a.endGuard)&&(a.startRe=r(a.trigger,a.guard,!0),a.triggerRe=new RegExp(a.trigger),a.endRe=r(a.endTrigger,a.endGuard,!0),a.endTriggerRe=new RegExp(a.endTrigger))}e||(e=[]),Array.isArray(e)?e.forEach(f):Object.keys(e).forEach(function(a){f(e[a])}),this._signal("registerSnippets",{scope:t})},this.unregister=function(e,t){var s=this.snippetMap,i=this.snippetNameMap;function c(o){var r=i[o.scope||t];if(r&&r[o.name]){delete r[o.name];var f=s[o.scope||t],a=f&&f.indexOf(o);a>=0&&f.splice(a,1)}}e.content?c(e):Array.isArray(e)&&e.forEach(c)},this.parseSnippetFile=function(e){e=e.replace(/\r/g,"");for(var c,t=[],s={},i=/^#.*|^({[\s\S]*})\s*$|^(\S+) (.*)$|^((?:\n*\t.*)+)/gm;c=i.exec(e);){if(c[1])try{s=JSON.parse(c[1]),t.push(s)}catch(a){}if(c[4])s.content=c[4].replace(/^\t/gm,""),t.push(s),s={};else{var o=c[2],r=c[3];if("regex"==o){var f=/\/((?:[^\/\\]|\\.)*)|$/g;s.guard=f.exec(r)[1],s.trigger=f.exec(r)[1],s.endTrigger=f.exec(r)[1],s.endGuard=f.exec(r)[1]}else"snippet"==o?(s.tabTrigger=r.match(/^\S*/)[0],s.name||(s.name=r)):o&&(s[o]=r)}}return t},this.getSnippetByName=function(e,t){var i,s=this.snippetNameMap;return this.getActiveScopes(t).some(function(c){var o=s[c];return o&&(i=o[e]),!!i},this),i}}).call(R.prototype);var h=function(n){if(n.tabstopManager)return n.tabstopManager;n.tabstopManager=this,this.$onChange=this.onChange.bind(this),this.$onChangeSelection=A.delayedCall(this.onChangeSelection.bind(this)).schedule,this.$onChangeSession=this.onChangeSession.bind(this),this.$onAfterExec=this.onAfterExec.bind(this),this.attach(n)};(function(){this.attach=function(n){this.index=0,this.ranges=[],this.tabstops=[],this.$openTabstops=null,this.selectedTabstop=null,this.editor=n,this.editor.on("change",this.$onChange),this.editor.on("changeSelection",this.$onChangeSelection),this.editor.on("changeSession",this.$onChangeSession),this.editor.commands.on("afterExec",this.$onAfterExec),this.editor.keyBinding.addKeyboardHandler(this.keyboardHandler)},this.detach=function(){this.tabstops.forEach(this.removeTabstopMarkers,this),this.ranges=null,this.tabstops=null,this.selectedTabstop=null,this.editor.removeListener("change",this.$onChange),this.editor.removeListener("changeSelection",this.$onChangeSelection),this.editor.removeListener("changeSession",this.$onChangeSession),this.editor.commands.removeListener("afterExec",this.$onAfterExec),this.editor.keyBinding.removeKeyboardHandler(this.keyboardHandler),this.editor.tabstopManager=null,this.editor=null},this.onChange=function(n){for(var e="r"==n.action[0],t=this.selectedTabstop||{},s=t.parents||{},i=(this.tabstops||[]).slice(),c=0;c<i.length;c++){var o=i[c];if(o.rangeList.$bias=o==t||s[o.index]?0:1,"remove"==n.action&&o!==t){var f=o.parents&&o.parents[t.index],a=o.rangeList.pointIndex(n.start,f);a=a<0?-a-1:a+1;for(var u=o.rangeList.pointIndex(n.end,f),_=o.rangeList.ranges.slice(a,u=u<0?-u-1:u-1),m=0;m<_.length;m++)this.removeRange(_[m])}o.rangeList.$onChange(n)}var d=this.editor.session;!this.$inChange&&e&&1==d.getLength()&&!d.getValue()&&this.detach()},this.updateLinkedFields=function(){var n=this.selectedTabstop;if(n&&n.hasLinkedRanges&&n.firstNonLinked){this.$inChange=!0;for(var e=this.editor.session,t=e.getTextRange(n.firstNonLinked),s=0;s<n.length;s++){var i=n[s];if(i.linked){var o=b.snippetManager.tmStrFormat(t,i.original,this.editor);e.replace(i,o)}}this.$inChange=!1}},this.onAfterExec=function(n){n.command&&!n.command.readOnly&&this.updateLinkedFields()},this.onChangeSelection=function(){if(this.editor){for(var n=this.editor.selection.lead,e=this.editor.selection.anchor,t=this.editor.selection.isEmpty(),s=0;s<this.ranges.length;s++)if(!this.ranges[s].linked){var i=this.ranges[s].contains(n.row,n.column),c=t||this.ranges[s].contains(e.row,e.column);if(i&&c)return}this.detach()}},this.onChangeSession=function(){this.detach()},this.tabNext=function(n){var e=this.tabstops.length,t=this.index+(n||1);(t=Math.min(Math.max(t,1),e))==e&&(t=0),this.selectTabstop(t),0===t&&this.detach()},this.selectTabstop=function(n){this.$openTabstops=null;var e=this.tabstops[this.index];if(e&&this.addTabstopMarkers(e),this.index=n,(e=this.tabstops[this.index])&&e.length){this.selectedTabstop=e;var t=e.firstNonLinked||e;if(e.choices&&(t.cursor=t.start),this.editor.inVirtualSelectionMode)this.editor.selection.fromOrientedRange(t);else{var s=this.editor.multiSelect;s.toSingleRange(t);for(var i=0;i<e.length;i++)e.hasLinkedRanges&&e[i].linked||s.addRange(e[i].clone(),!0)}this.editor.keyBinding.addKeyboardHandler(this.keyboardHandler),this.selectedTabstop&&this.selectedTabstop.choices&&this.editor.execCommand("startAutocomplete",{matches:this.selectedTabstop.choices})}},this.addTabstops=function(n,e,t){var s=this.useLink||!this.editor.getOption("enableMultiselect");if(this.$openTabstops||(this.$openTabstops=[]),!n[0]){var i=$.fromPoints(t,t);p(i.start,e),p(i.end,e),n[0]=[i],n[0].index=0}var o=[this.index+1,0],r=this.ranges;n.forEach(function(f,a){for(var u=this.$openTabstops[a]||f,_=0;_<f.length;_++){var m=f[_],d=$.fromPoints(m.start,m.end||m.start);l(d.start,e),l(d.end,e),d.original=m,d.tabstop=u,r.push(d),u!=f?u.unshift(d):u[_]=d,m.fmtString||u.firstNonLinked&&s?(d.linked=!0,u.hasLinkedRanges=!0):u.firstNonLinked||(u.firstNonLinked=d)}u.firstNonLinked||(u.hasLinkedRanges=!1),u===f&&(o.push(u),this.$openTabstops[a]=u),this.addTabstopMarkers(u),u.rangeList=u.rangeList||new S,u.rangeList.$bias=0,u.rangeList.addList(u)},this),o.length>2&&(this.tabstops.length&&o.push(o.splice(2,1)[0]),this.tabstops.splice.apply(this.tabstops,o))},this.addTabstopMarkers=function(n){var e=this.editor.session;n.forEach(function(t){t.markerId||(t.markerId=e.addMarker(t,"ace_snippet-marker","text"))})},this.removeTabstopMarkers=function(n){var e=this.editor.session;n.forEach(function(t){e.removeMarker(t.markerId),t.markerId=null})},this.removeRange=function(n){var e=n.tabstop.indexOf(n);-1!=e&&n.tabstop.splice(e,1),-1!=(e=this.ranges.indexOf(n))&&this.ranges.splice(e,1),-1!=(e=n.tabstop.rangeList.ranges.indexOf(n))&&n.tabstop.splice(e,1),this.editor.session.removeMarker(n.markerId),n.tabstop.length||(-1!=(e=this.tabstops.indexOf(n.tabstop))&&this.tabstops.splice(e,1),this.tabstops.length||this.detach())},this.keyboardHandler=new k,this.keyboardHandler.bindKeys({Tab:function(n){b.snippetManager&&b.snippetManager.expandWithTab(n)||(n.tabstopManager.tabNext(1),n.renderer.scrollCursorIntoView())},"Shift-Tab":function(n){n.tabstopManager.tabNext(-1),n.renderer.scrollCursorIntoView()},Esc:function(n){n.tabstopManager.detach()}})}).call(h.prototype);var l=function(n,e){0==n.row&&(n.column+=e.column),n.row+=e.row},p=function(n,e){n.row==e.row&&(n.column-=e.column),n.row-=e.row};U.importCssString("\n.ace_snippet-marker {\n    -moz-box-sizing: border-box;\n    box-sizing: border-box;\n    background: rgba(194, 193, 208, 0.09);\n    border: 1px dotted rgba(211, 208, 235, 0.62);\n    position: absolute;\n}","snippets.css",!1),b.snippetManager=new R;var g=T("./editor").Editor;(function(){this.insertSnippet=function(n,e){return b.snippetManager.insertSnippet(this,n,e)},this.expandSnippet=function(n){return b.snippetManager.expandWithTab(this,n)}}).call(g.prototype)}),ace.define("ace/ext/emmet",["require","exports","module","ace/keyboard/hash_handler","ace/editor","ace/snippets","ace/range","ace/config","resources","resources","tabStops","resources","utils","actions"],function(T,b,D){"use strict";var S,k,U=T("../keyboard/hash_handler").HashHandler,V=T("../editor").Editor,z=T("../snippets").snippetManager,A=T("../range").Range,$=T("../config"),O=function(){function h(){}return h.prototype.setupContext=function(l){this.ace=l,this.indentation=l.session.getTabString(),S||(S=window.emmet),(S.resources||S.require("resources")).setVariable("indentation",this.indentation),this.$syntax=null,this.$syntax=this.getSyntax()},h.prototype.getSelectionRange=function(){var l=this.ace.getSelectionRange(),p=this.ace.session.doc;return{start:p.positionToIndex(l.start),end:p.positionToIndex(l.end)}},h.prototype.createSelection=function(l,p){var g=this.ace.session.doc;this.ace.selection.setRange({start:g.indexToPosition(l),end:g.indexToPosition(p)})},h.prototype.getCurrentLineRange=function(){var l=this.ace,p=l.getCursorPosition().row,g=l.session.getLine(p).length,n=l.session.doc.positionToIndex({row:p,column:0});return{start:n,end:n+g}},h.prototype.getCaretPos=function(){var l=this.ace.getCursorPosition();return this.ace.session.doc.positionToIndex(l)},h.prototype.setCaretPos=function(l){var p=this.ace.session.doc.indexToPosition(l);this.ace.selection.moveToPosition(p)},h.prototype.getCurrentLine=function(){var l=this.ace.getCursorPosition().row;return this.ace.session.getLine(l)},h.prototype.replaceContent=function(l,p,g,n){null==g&&(g=null==p?this.getContent().length:p),null==p&&(p=0);var e=this.ace,t=e.session.doc,s=A.fromPoints(t.indexToPosition(p),t.indexToPosition(g));e.session.remove(s),s.end=s.start,l=this.$updateTabstops(l),z.insertSnippet(e,l)},h.prototype.getContent=function(){return this.ace.getValue()},h.prototype.getSyntax=function(){if(this.$syntax)return this.$syntax;var l=this.ace.session.$modeId.split("/").pop();if("html"==l||"php"==l){var p=this.ace.getCursorPosition(),g=this.ace.session.getState(p.row);"string"!=typeof g&&(g=g[0]),g&&((g=g.split("-")).length>1?l=g[0]:"php"==l&&(l="html"))}return l},h.prototype.getProfileName=function(){var l=S.resources||S.require("resources");switch(this.getSyntax()){case"css":return"css";case"xml":case"xsl":return"xml";case"html":var p=l.getVariable("profile");return p||(p=-1!=this.ace.session.getLines(0,2).join("").search(/<!DOCTYPE[^>]+XHTML/i)?"xhtml":"html"),p;default:var g=this.ace.session.$mode;return g.emmetConfig&&g.emmetConfig.profile||"xhtml"}},h.prototype.prompt=function(l){return prompt(l)},h.prototype.getSelection=function(){return this.ace.session.getTextRange()},h.prototype.getFilePath=function(){return""},h.prototype.$updateTabstops=function(l){var g=0,n=null,e=S.tabStops||S.require("tabStops"),s=(S.resources||S.require("resources")).getVocabulary("user"),i={tabstop:function(o){var r=parseInt(o.group,10),f=0===r;f?r=++g:r+=1e3;var a=o.placeholder;a&&(a=e.processText(a,i));var u="${"+r+(a?":"+a:"")+"}";return f&&(n=[o.start,u]),u},escape:function(o){return"$"==o?"\\$":"\\"==o?"\\\\":o}};return l=e.processText(l,i),s.variables.insert_final_tabstop&&!/\$\{0\}$/.test(l)?l+="${0}":n&&(l=(S.utils?S.utils.common:S.require("utils")).replaceSubstring(l,"${0}",n[0],n[1])),l},h}(),N={expand_abbreviation:{mac:"ctrl+alt+e",win:"alt+e"},match_pair_outward:{mac:"ctrl+d",win:"ctrl+,"},match_pair_inward:{mac:"ctrl+j",win:"ctrl+shift+0"},matching_pair:{mac:"ctrl+alt+j",win:"alt+j"},next_edit_point:"alt+right",prev_edit_point:"alt+left",toggle_comment:{mac:"command+/",win:"ctrl+/"},split_join_tag:{mac:"shift+command+'",win:"shift+ctrl+`"},remove_tag:{mac:"command+'",win:"shift+ctrl+;"},evaluate_math_expression:{mac:"shift+command+y",win:"shift+ctrl+y"},increment_number_by_1:"ctrl+up",decrement_number_by_1:"ctrl+down",increment_number_by_01:"alt+up",decrement_number_by_01:"alt+down",increment_number_by_10:{mac:"alt+command+up",win:"shift+alt+up"},decrement_number_by_10:{mac:"alt+command+down",win:"shift+alt+down"},select_next_item:{mac:"shift+command+.",win:"shift+ctrl+."},select_previous_item:{mac:"shift+command+,",win:"shift+ctrl+,"},reflect_css_value:{mac:"shift+command+r",win:"shift+ctrl+r"},encode_decode_data_url:{mac:"shift+ctrl+d",win:"ctrl+'"},expand_abbreviation_with_tab:"Tab",wrap_with_abbreviation:{mac:"shift+ctrl+a",win:"shift+ctrl+a"}},C=new O;for(var E in b.commands=new U,b.runEmmetCommand=function h(l){if("expand_abbreviation_with_tab"==this.action){if(!l.selection.isEmpty())return!1;var p=l.selection.lead,g=l.session.getTokenAt(p.row,p.column);if(g&&/\btag\b/.test(g.type))return!1}try{C.setupContext(l);var n=S.actions||S.require("actions");if("wrap_with_abbreviation"==this.action)return setTimeout(function(){n.run("wrap_with_abbreviation",C)},0);var e=n.run(this.action,C)}catch(s){if(!S){var t=b.load(h.bind(this,l));return"expand_abbreviation_with_tab"!=this.action&&t}l._signal("changeStatus","string"==typeof s?s:s.message),$.warn(s),e=!1}return e},N)b.commands.addCommand({name:"emmet:"+E,action:E,bindKey:N[E],exec:b.runEmmetCommand,multiSelectAction:"forEach"});b.updateCommands=function(h,l){l?h.keyBinding.addKeyboardHandler(b.commands):h.keyBinding.removeKeyboardHandler(b.commands)},b.isSupportedMode=function(h){return!!h&&(!!h.emmetConfig||/css|less|scss|sass|stylus|html|php|twig|ejs|handlebars/.test(h.$id||h))},b.isAvailable=function(h,l){if(/(evaluate_math_expression|expand_abbreviation)$/.test(l))return!0;var p=h.session.$mode,g=b.isSupportedMode(p);if(g&&p.$modes)try{C.setupContext(h),/js|php/.test(C.getSyntax())&&(g=!1)}catch(n){}return g};var R=function(h,l){var p=l;if(p){var g=b.isSupportedMode(p.session.$mode);!1===h.enableEmmet&&(g=!1),g&&b.load(),b.updateCommands(p,g)}};b.load=function(h){return"string"!=typeof k?($.warn("script for emmet-core is not loaded"),!1):($.loadModule(k,function(){k=null,h&&h()}),!0)},b.AceEmmetEditor=O,$.defineOptions(V.prototype,"editor",{enableEmmet:{set:function(h){this[h?"on":"removeListener"]("changeMode",R),R({enableEmmet:!!h},this)},value:!0}}),b.setCore=function(h){"string"==typeof h?k=h:S=h}}),ace.require(["ace/ext/emmet"],function(T){"object"==typeof module&&"object"==typeof exports&&module&&(module.exports=T)});