/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.tools.commandtools;

import java.util.Arrays;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.Options;
import org.apache.helix.HelixManager;
import org.apache.helix.HelixManagerFactory;
import org.apache.helix.InstanceType;
import org.apache.helix.examples.BrokerResourceOnlineOfflineStateModelFactory;
import org.apache.helix.examples.LeaderStandbyStateModelFactory;
import org.apache.helix.examples.MasterSlaveStateModelFactory;
import org.apache.helix.examples.OnlineOfflineStateModelFactory;
import org.apache.helix.examples.SegmentOnlineOfflineStateModelFactory;
import org.apache.helix.manager.zk.HelixManagerShutdownHook;
import org.apache.helix.messaging.handling.MessageHandlerFactory;
import org.apache.helix.model.Message;
import org.apache.helix.participant.StateMachineEngine;
import org.apache.helix.participant.statemachine.StateModel;
import org.apache.helix.participant.statemachine.StateModelFactory;
import org.apache.helix.tools.commandtools.ToolsUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExampleParticipant {
    private static final Logger LOG = LoggerFactory.getLogger(ExampleParticipant.class);
    public static final String zkServer = "zkSvr";
    public static final String cluster = "cluster";
    public static final String instances = "instances";
    public static final String help = "help";
    public static final String transDelay = "transDelay";
    private final String zkConnectString;
    private final String clusterName;
    private final String instanceName;
    private HelixManager manager;
    private StateModelFactory<StateModel> stateModelFactory;
    private final int delay;

    public ExampleParticipant(String zkConnectString, String clusterName, String instanceName, int delay) {
        this.zkConnectString = zkConnectString;
        this.clusterName = clusterName;
        this.instanceName = instanceName;
        this.delay = delay;
    }

    public void start() throws Exception {
        this.manager = HelixManagerFactory.getZKHelixManager(this.clusterName, this.instanceName, InstanceType.PARTICIPANT, this.zkConnectString);
        StateMachineEngine stateMach = this.manager.getStateMachineEngine();
        stateMach.registerStateModelFactory("MasterSlave", new MasterSlaveStateModelFactory(this.instanceName, this.delay));
        stateMach.registerStateModelFactory("OnlineOffline", new OnlineOfflineStateModelFactory(this.instanceName, this.delay));
        stateMach.registerStateModelFactory("LeaderStandby", new LeaderStandbyStateModelFactory(this.instanceName, this.delay));
        stateMach.registerStateModelFactory("BrokerResourceOnlineOfflineStateModel", new BrokerResourceOnlineOfflineStateModelFactory());
        stateMach.registerStateModelFactory("SegmentOnlineOfflineStateModel", new SegmentOnlineOfflineStateModelFactory());
        this.manager.connect();
        this.manager.getMessagingService().registerMessageHandlerFactory(Message.MessageType.STATE_TRANSITION.name(), (MessageHandlerFactory)stateMach);
    }

    public void stop() {
        this.manager.disconnect();
    }

    public HelixManager getManager() {
        return this.manager;
    }

    private static Options constructCommandLineOptions() {
        OptionBuilder.withLongOpt((String)help);
        OptionBuilder.withDescription((String)"Prints command-line options info");
        Option helpOption = OptionBuilder.create();
        OptionBuilder.withLongOpt((String)zkServer);
        OptionBuilder.withDescription((String)"Provide zookeeper address");
        Option zkServerOption = OptionBuilder.create();
        zkServerOption.setArgs(1);
        zkServerOption.setRequired(true);
        zkServerOption.setArgName("ZookeeperServerAddress(Required)");
        OptionBuilder.withLongOpt((String)cluster);
        OptionBuilder.withDescription((String)"Provide cluster name");
        Option clusterOption = OptionBuilder.create();
        clusterOption.setArgs(1);
        clusterOption.setRequired(true);
        clusterOption.setArgName("Cluster name (Required)");
        OptionBuilder.withLongOpt((String)instances);
        OptionBuilder.withDescription((String)"Provide instance names, separated by ':");
        Option instancesOption = OptionBuilder.create();
        instancesOption.setArgs(1);
        instancesOption.setRequired(true);
        instancesOption.setArgName("Instance names (Required)");
        OptionBuilder.withLongOpt((String)transDelay);
        OptionBuilder.withDescription((String)"Provide state trans delay");
        Option transDelayOption = OptionBuilder.create();
        transDelayOption.setArgs(1);
        transDelayOption.setRequired(false);
        transDelayOption.setArgName("Delay time in state transition, in MS");
        OptionGroup optionGroup = new OptionGroup();
        optionGroup.addOption(zkServerOption);
        Options options = new Options();
        options.addOption(helpOption);
        options.addOption(clusterOption);
        options.addOption(instancesOption);
        options.addOption(transDelayOption);
        options.addOptionGroup(optionGroup);
        return options;
    }

    public static void printUsage(Options cliOptions) {
        HelpFormatter helpFormatter = new HelpFormatter();
        helpFormatter.setWidth(1000);
        helpFormatter.printHelp("java " + ExampleParticipant.class.getName(), cliOptions);
    }

    public static void main(String[] args) throws Exception {
        int delay = 0;
        CommandLine cmd = ToolsUtil.processCommandLineArgs(args, ExampleParticipant.constructCommandLineOptions());
        String zkConnectString = cmd.getOptionValue(zkServer);
        String clusterName = cmd.getOptionValue(cluster);
        String instanceNames = cmd.getOptionValue(instances);
        List<String> hosts = Arrays.asList(instanceNames.split(":"));
        if (cmd.hasOption(transDelay)) {
            try {
                delay = Integer.parseInt(cmd.getOptionValue(transDelay));
                if (delay < 0) {
                    throw new Exception("delay must be positive");
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                delay = 0;
            }
        }
        System.out.println("Starting Instances with ZK:" + zkConnectString + ", cluster: " + clusterName + ", instances: " + hosts);
        for (String instanceName : hosts) {
            System.out.println("Starting Instance:" + instanceName);
            ExampleParticipant process = new ExampleParticipant(zkConnectString, clusterName, instanceName, delay);
            process.start();
            System.out.println("Started Instance:" + instanceName);
            Runtime.getRuntime().addShutdownHook(new HelixManagerShutdownHook(process.getManager()));
        }
        Thread.currentThread().join();
    }
}

