/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.controller.rebalancer.strategy.crushMapping;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Random;
import java.util.Set;
import java.util.TreeMap;
import org.apache.helix.controller.rebalancer.topology.InstanceNode;
import org.apache.helix.controller.rebalancer.topology.Node;
import org.apache.helix.controller.rebalancer.topology.Topology;

public class CardDealingAdjustmentAlgorithmV2 {
    private static int MAX_ADJUSTMENT = 2;
    private Mode _mode;
    protected int _replica;
    protected Map<Node, Node> _instanceFaultZone = new HashMap<Node, Node>();
    protected Map<Node, Long> _instanceWeight = new HashMap<Node, Long>();
    protected long _totalWeight = 0L;
    protected Map<Node, Long> _faultZoneWeight = new HashMap<Node, Long>();
    protected Map<Node, Set<String>> _faultZonePartitionMap = new HashMap<Node, Set<String>>();

    public CardDealingAdjustmentAlgorithmV2(Topology topology, int replica, Mode mode) {
        this._mode = mode;
        this._replica = replica;
        for (Node zone : topology.getFaultZones()) {
            this._faultZoneWeight.put(zone, zone.getWeight());
            if (!this._faultZonePartitionMap.containsKey(zone)) {
                this._faultZonePartitionMap.put(zone, new HashSet());
            }
            for (Node instance : Topology.getAllLeafNodes(zone)) {
                if (!(instance instanceof InstanceNode) || instance.isFailed()) continue;
                this._instanceWeight.put(instance, instance.getWeight());
                this._totalWeight += instance.getWeight();
                this._instanceFaultZone.put(instance, zone);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public boolean computeMapping(Map<Node, List<String>> nodeToPartitionMap, int randomSeed) {
        TreeMap<String, Integer> toBeReassigned = new TreeMap<String, Integer>();
        long totalReplicaCount = 0L;
        for (List<String> list : nodeToPartitionMap.values()) {
            totalReplicaCount += (long)list.size();
        }
        if (totalReplicaCount == 0L || this._replica > this._faultZoneWeight.size()) {
            return false;
        }
        HashMap<Node, Float> targetPartitionCount = new HashMap<Node, Float>();
        for (Node liveInstance : this._instanceFaultZone.keySet()) {
            long zoneWeight = this._faultZoneWeight.get(this._instanceFaultZone.get(liveInstance));
            float instanceRatioInZone = (float)this._instanceWeight.get(liveInstance).longValue() / (float)zoneWeight;
            float zonePartitions = this._replica == this._faultZoneWeight.size() ? (float)totalReplicaCount / (float)this._faultZoneWeight.size() : (float)totalReplicaCount * (float)zoneWeight / (float)this._totalWeight;
            targetPartitionCount.put(liveInstance, Float.valueOf(instanceRatioInZone * zonePartitions));
        }
        boolean bl = false;
        HashMap<Node, Integer> maxZoneOverflows = new HashMap<Node, Integer>();
        if (this._mode.equals((Object)Mode.MINIMIZE_MOVEMENT)) {
            int n = (int)totalReplicaCount % this._instanceFaultZone.size();
            for (Node faultZone : this._faultZoneWeight.keySet()) {
                float zoneWeight = this._faultZoneWeight.get(faultZone).longValue();
                maxZoneOverflows.put(faultZone, (int)Math.ceil((float)n * zoneWeight / (float)this._totalWeight));
            }
        }
        Iterator<Node> nodeIter = nodeToPartitionMap.keySet().iterator();
        while (nodeIter.hasNext()) {
            Node instance = nodeIter.next();
            if (this._instanceFaultZone.containsKey(instance)) continue;
            List<String> partitions = nodeToPartitionMap.get(instance);
            this.addToReAssignPartition(toBeReassigned, partitions);
            partitions.clear();
            nodeIter.remove();
        }
        ArrayList<Node> orderedInstances = new ArrayList<Node>(this._instanceFaultZone.keySet());
        Collections.shuffle(orderedInstances, new Random(randomSeed));
        for (Node instance : orderedInstances) {
            if (!nodeToPartitionMap.containsKey(instance)) continue;
            List<String> partitions = nodeToPartitionMap.get(instance);
            int target = (int)Math.floor(((Float)targetPartitionCount.get(instance)).floatValue());
            if (partitions.size() > target) {
                void var7_10;
                Integer maxZoneOverflow = (Integer)maxZoneOverflows.get(this._instanceFaultZone.get(instance));
                if (maxZoneOverflow != null && maxZoneOverflow > 0 && var7_10 > 0) {
                    target = (int)Math.ceil(((Float)targetPartitionCount.get(instance)).floatValue());
                    maxZoneOverflows.put(this._instanceFaultZone.get(instance), maxZoneOverflow - 1);
                    --var7_10;
                }
                Collections.shuffle(partitions, new Random(instance.hashCode() * 31 + randomSeed));
                this.addToReAssignPartition(toBeReassigned, partitions.subList(target, partitions.size()));
                ArrayList<String> remainingPartitions = new ArrayList<String>(partitions.subList(0, target));
                partitions.clear();
                nodeToPartitionMap.put(instance, remainingPartitions);
            }
            this._faultZonePartitionMap.get(this._instanceFaultZone.get(instance)).addAll((Collection<String>)nodeToPartitionMap.get(instance));
        }
        int adjustment = 0;
        while (!toBeReassigned.isEmpty() && adjustment <= MAX_ADJUSTMENT) {
            this.partitionDealing(this._instanceFaultZone.keySet(), toBeReassigned, this._faultZonePartitionMap, this._instanceFaultZone, nodeToPartitionMap, targetPartitionCount, randomSeed, adjustment++);
        }
        return toBeReassigned.isEmpty();
    }

    private void partitionDealing(Collection<Node> instances, TreeMap<String, Integer> toBeReassigned, Map<Node, Set<String>> faultZonePartitionMap, Map<Node, Node> faultZoneMap, final Map<Node, List<String>> assignmentMap, final Map<Node, Float> targetPartitionCount, final int randomSeed, int targetAdjustment) {
        PriorityQueue<Node> instanceQueue = new PriorityQueue<Node>(instances.size(), new Comparator<Node>(){

            @Override
            public int compare(Node node1, Node node2) {
                int node2Load;
                int node1Load = assignmentMap.containsKey(node1) ? ((List)assignmentMap.get(node1)).size() : 0;
                int n = node2Load = assignmentMap.containsKey(node2) ? ((List)assignmentMap.get(node2)).size() : 0;
                if (node1Load == node2Load) {
                    Float node2Target;
                    Float node1Target;
                    if (CardDealingAdjustmentAlgorithmV2.this._mode.equals((Object)Mode.EVENNESS) && (node1Target = (Float)targetPartitionCount.get(node1)) != (node2Target = (Float)targetPartitionCount.get(node2))) {
                        return node2Target.compareTo(node1Target);
                    }
                    return new Integer((node1.getName() + randomSeed).hashCode()).compareTo((node2.getName() + randomSeed).hashCode());
                }
                return node1Load - node2Load;
            }
        });
        instanceQueue.addAll(instances);
        while (!toBeReassigned.isEmpty()) {
            boolean anyPartitionAssigned = false;
            Iterator<Node> instanceIter = instanceQueue.iterator();
            while (instanceIter.hasNext()) {
                int space;
                Node instance = instanceIter.next();
                instanceIter.remove();
                boolean partitionAssignedToInstance = false;
                Node faultZone = faultZoneMap.get(instance);
                List<Object> partitions = assignmentMap.containsKey(instance) ? assignmentMap.get(instance) : new ArrayList();
                int n = space = instance.getWeight() <= 0L ? 0 : (int)Math.floor(targetPartitionCount.get(instance).floatValue()) + targetAdjustment - partitions.size();
                if (space > 0) {
                    for (String pendingPartition : toBeReassigned.navigableKeySet()) {
                        if (faultZonePartitionMap.get(faultZone).contains(pendingPartition)) continue;
                        if (!assignmentMap.containsKey(instance)) {
                            assignmentMap.put(instance, partitions);
                        }
                        partitions.add(pendingPartition);
                        faultZonePartitionMap.get(faultZone).add(pendingPartition);
                        if (toBeReassigned.get(pendingPartition) == 1) {
                            toBeReassigned.remove(pendingPartition);
                        } else {
                            toBeReassigned.put(pendingPartition, toBeReassigned.get(pendingPartition) - 1);
                        }
                        partitionAssignedToInstance = true;
                        break;
                    }
                }
                if (!partitionAssignedToInstance) continue;
                instanceQueue.add(instance);
                anyPartitionAssigned = true;
                break;
            }
            if (anyPartitionAssigned) continue;
            break;
        }
    }

    private void addToReAssignPartition(TreeMap<String, Integer> toBeReassigned, List<String> partitions) {
        for (String partition : partitions) {
            if (!toBeReassigned.containsKey(partition)) {
                toBeReassigned.put(partition, 1);
                continue;
            }
            toBeReassigned.put(partition, toBeReassigned.get(partition) + 1);
        }
    }

    public static enum Mode {
        MINIMIZE_MOVEMENT,
        EVENNESS;

    }
}

