/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.compute.task;

import java.time.Instant;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.apache.ignite3.compute.JobExecution;
import org.apache.ignite3.compute.JobState;
import org.apache.ignite3.compute.JobStatus;
import org.apache.ignite3.compute.TaskState;
import org.apache.ignite3.compute.TaskStatus;
import org.apache.ignite3.compute.task.MapReduceJob;
import org.apache.ignite3.compute.task.MapReduceTask;
import org.apache.ignite3.compute.task.TaskExecutionContext;
import org.apache.ignite3.internal.compute.CancellableTaskExecution;
import org.apache.ignite3.internal.compute.ComputeUtils;
import org.apache.ignite3.internal.compute.HybridTimestampProvider;
import org.apache.ignite3.internal.compute.MarshallerProvider;
import org.apache.ignite3.internal.compute.ResultUnmarshallingJobExecution;
import org.apache.ignite3.internal.compute.TaskStateImpl;
import org.apache.ignite3.internal.compute.events.ComputeEventMetadata;
import org.apache.ignite3.internal.compute.events.ComputeEventMetadataBuilder;
import org.apache.ignite3.internal.compute.events.ComputeEventsFactory;
import org.apache.ignite3.internal.compute.queue.PriorityQueueExecutor;
import org.apache.ignite3.internal.compute.queue.QueueExecution;
import org.apache.ignite3.internal.compute.task.JobSubmitter;
import org.apache.ignite3.internal.eventlog.api.EventLog;
import org.apache.ignite3.internal.eventlog.api.IgniteEventType;
import org.apache.ignite3.internal.lang.IgniteBiTuple;
import org.apache.ignite3.internal.logger.IgniteLogger;
import org.apache.ignite3.internal.logger.Loggers;
import org.apache.ignite3.internal.util.ArrayUtils;
import org.apache.ignite3.internal.util.CompletableFutures;
import org.apache.ignite3.lang.CancelHandle;
import org.apache.ignite3.marshalling.Marshaller;
import org.jetbrains.annotations.Nullable;

public class TaskExecutionInternal<I, M, T, R>
implements CancellableTaskExecution<R>,
MarshallerProvider<R>,
HybridTimestampProvider {
    private static final IgniteLogger LOG = Loggers.forClass(TaskExecutionInternal.class);
    private final QueueExecution<SplitResult<I, M, T, R>> splitExecution;
    private final CompletableFuture<List<JobExecution<T>>> executionsFuture;
    private final CompletableFuture<IgniteBiTuple<Map<UUID, T>, Long>> resultsFuture;
    private final CompletableFuture<QueueExecution<R>> reduceExecutionFuture;
    private final AtomicReference<TaskState> reduceFailedState = new AtomicReference();
    private final CancelHandle cancelHandle = CancelHandle.create();
    private final EventLog eventLog;
    private final AtomicBoolean isCancelled;
    private final UUID taskId = UUID.randomUUID();
    private final ComputeEventMetadata eventMetadata;
    @Nullable
    private volatile Marshaller<R, byte[]> reduceResultMarshallerRef;

    public TaskExecutionInternal(PriorityQueueExecutor executorService, EventLog eventLog, JobSubmitter<M, T> jobSubmitter, Class<? extends MapReduceTask<I, M, T, R>> taskClass, TaskExecutionContext context, AtomicBoolean isCancelled, ComputeEventMetadataBuilder metadataBuilder, @Nullable I arg) {
        this.eventLog = eventLog;
        this.isCancelled = isCancelled;
        this.eventMetadata = metadataBuilder.taskId(this.taskId).build();
        LOG.debug("Executing task {}", taskClass.getName());
        ComputeEventsFactory.logEvent(eventLog, IgniteEventType.COMPUTE_TASK_QUEUED, this.eventMetadata);
        this.splitExecution = executorService.submit(() -> {
            ComputeEventsFactory.logEvent(eventLog, IgniteEventType.COMPUTE_TASK_EXECUTING, this.eventMetadata);
            MapReduceTask task = ComputeUtils.instantiateTask(taskClass);
            this.reduceResultMarshallerRef = task.reduceJobResultMarshaller();
            Class<?> splitArgumentType = ComputeUtils.getTaskSplitArgumentType(taskClass);
            Object input = ComputeUtils.unmarshalOrNotIfNull(task.splitJobInputMarshaller(), arg, splitArgumentType, taskClass.getClassLoader());
            return task.splitAsync(context, input).thenApply(jobs -> new SplitResult(task, jobs));
        }, Integer.MAX_VALUE, 0);
        this.executionsFuture = this.splitExecution.resultAsync().thenCompose(splitResult -> {
            List runners = splitResult.runners();
            LOG.debug("Submitting {} jobs for {}", runners.size(), taskClass.getName());
            return jobSubmitter.submit(runners, metadataBuilder, this.cancelHandle.token());
        });
        this.resultsFuture = this.executionsFuture.thenCompose(TaskExecutionInternal::resultsAsync);
        this.reduceExecutionFuture = ((CompletableFuture)this.resultsFuture.thenApply(results -> {
            LOG.debug("Running reduce job for {}", taskClass.getName());
            MapReduceTask task = (MapReduceTask)((CompletableFuture)this.splitExecution.resultAsync().thenApply(rec$ -> ((SplitResult)rec$).task())).join();
            Map resMap = (Map)results.get1();
            assert (resMap != null) : "Results map should not be null";
            return executorService.submit(() -> task.reduceAsync(context, resMap), Integer.MAX_VALUE, 0);
        })).whenComplete(this::captureReduceExecution);
    }

    private void captureReduceExecution(QueueExecution<R> reduceExecution, Throwable throwable) {
        if (throwable != null) {
            this.captureReduceSubmitFailure(throwable);
        } else {
            this.handleReduceResult(reduceExecution);
        }
    }

    private void captureReduceSubmitFailure(Throwable throwable) {
        TaskStatus status = this.isCancelled.get() ? TaskStatus.CANCELED : TaskStatus.FAILED;
        ComputeEventsFactory.logEvent(this.eventLog, status == TaskStatus.CANCELED ? IgniteEventType.COMPUTE_TASK_CANCELED : IgniteEventType.COMPUTE_TASK_FAILED, this.eventMetadata);
        JobState state = this.splitExecution.state();
        if (state != null) {
            this.reduceFailedState.set(TaskStateImpl.toBuilder(state).id(this.taskId).status(status).finishTime(Instant.now()).build());
        }
    }

    private void handleReduceResult(QueueExecution<R> reduceExecution) {
        reduceExecution.resultAsync().whenComplete((result, throwable) -> {
            if (result != null) {
                ComputeEventsFactory.logEvent(this.eventLog, IgniteEventType.COMPUTE_TASK_COMPLETED, this.eventMetadata);
            } else {
                JobState reduceState = reduceExecution.state();
                if (reduceState != null) {
                    IgniteEventType type = reduceState.status() == JobStatus.FAILED ? IgniteEventType.COMPUTE_TASK_FAILED : IgniteEventType.COMPUTE_TASK_CANCELED;
                    ComputeEventsFactory.logEvent(this.eventLog, type, this.eventMetadata);
                }
            }
        });
    }

    @Override
    public CompletableFuture<R> resultAsync() {
        return this.reduceExecutionFuture.thenCompose(QueueExecution::resultAsync);
    }

    @Override
    public CompletableFuture<@Nullable TaskState> stateAsync() {
        JobState splitState = this.splitExecution.state();
        if (splitState == null) {
            return CompletableFutures.nullCompletedFuture();
        }
        if (splitState.status() != JobStatus.COMPLETED) {
            return CompletableFuture.completedFuture(TaskStateImpl.toBuilder(splitState).id(this.taskId).build());
        }
        if (this.reduceExecutionFuture.isDone()) {
            return this.reduceExecutionFuture.handle((reduceExecution, throwable) -> {
                if (throwable == null) {
                    JobState reduceState = reduceExecution.state();
                    if (reduceState == null) {
                        return null;
                    }
                    return TaskStateImpl.toBuilder(reduceState).id(this.taskId).createTime(splitState.createTime()).startTime(splitState.startTime()).build();
                }
                return this.reduceFailedState.get();
            });
        }
        return CompletableFuture.completedFuture(TaskStateImpl.toBuilder(splitState).id(this.taskId).status(TaskStatus.EXECUTING).finishTime(null).build());
    }

    @Override
    public CompletableFuture<@Nullable Boolean> cancelAsync() {
        if (!this.isCancelled.compareAndSet(false, true)) {
            return CompletableFutures.falseCompletedFuture();
        }
        if (this.splitExecution.cancel()) {
            this.executionsFuture.cancel(true);
            return CompletableFutures.trueCompletedFuture();
        }
        if (this.executionsFuture.cancel(true)) {
            return CompletableFutures.trueCompletedFuture();
        }
        if (this.resultsFuture.cancel(true)) {
            return ((CompletableFuture)this.executionsFuture.thenCompose(unused -> this.cancelHandle.cancelAsync())).thenApply(unused -> true);
        }
        if (this.reduceExecutionFuture.cancel(true)) {
            return CompletableFutures.trueCompletedFuture();
        }
        return this.reduceExecutionFuture.thenApply(QueueExecution::cancel);
    }

    @Override
    public CompletableFuture<@Nullable Boolean> changePriorityAsync(int newPriority) {
        if (this.splitExecution.changePriority(newPriority)) {
            return CompletableFutures.trueCompletedFuture();
        }
        if (this.reduceExecutionFuture.isDone()) {
            return this.reduceExecutionFuture.thenApply(reduceExecution -> reduceExecution.changePriority(newPriority));
        }
        return this.executionsFuture.thenCompose(executions -> {
            CompletableFuture[] changePriorityFutures = (CompletableFuture[])executions.stream().map(execution -> execution.changePriorityAsync(newPriority)).toArray(CompletableFuture[]::new);
            return CompletableFuture.allOf(changePriorityFutures).thenApply(unused -> {
                List<@Nullable T> results = Arrays.stream(changePriorityFutures).map(CompletableFuture::join).collect(Collectors.toList());
                if (results.stream().allMatch(b -> b == Boolean.TRUE)) {
                    return true;
                }
                if (results.stream().anyMatch(Objects::isNull)) {
                    return null;
                }
                return false;
            });
        });
    }

    @Override
    public CompletableFuture<List<@Nullable JobState>> statesAsync() {
        return this.executionsFuture.thenCompose(executions -> {
            CompletableFuture[] stateFutures = (CompletableFuture[])executions.stream().map(JobExecution::stateAsync).toArray(CompletableFuture[]::new);
            return CompletableFutures.allOfToList(stateFutures);
        });
    }

    private static <T> CompletableFuture<IgniteBiTuple<Map<UUID, T>, Long>> resultsAsync(List<JobExecution<T>> executions) {
        CompletableFuture[] resultFutures = (CompletableFuture[])executions.stream().map(j -> ((ResultUnmarshallingJobExecution)j).resultWithTimestampAsync()).toArray(CompletableFuture[]::new);
        CompletableFuture[] idFutures = (CompletableFuture[])executions.stream().map(JobExecution::idAsync).toArray(CompletableFuture[]::new);
        return CompletableFuture.allOf(ArrayUtils.concat(resultFutures, idFutures)).thenApply(unused -> {
            LinkedHashMap results = new LinkedHashMap();
            long timestamp = 0L;
            for (int i = 0; i < resultFutures.length; ++i) {
                IgniteBiTuple jobRes = (IgniteBiTuple)resultFutures[i].join();
                results.put((UUID)idFutures[i].join(), jobRes.get1());
                Long jobTs = (Long)jobRes.get2();
                assert (jobTs != null) : "Job result timestamp should not be null";
                timestamp = Math.max(timestamp, jobTs);
            }
            return new IgniteBiTuple(results, timestamp);
        });
    }

    @Override
    @Nullable
    public Marshaller<R, byte[]> resultMarshaller() {
        return this.reduceResultMarshallerRef;
    }

    @Override
    public boolean marshalResult() {
        return false;
    }

    @Override
    public long hybridTimestamp() {
        if (this.resultsFuture.isCompletedExceptionally()) {
            return 0L;
        }
        IgniteBiTuple res = this.resultsFuture.getNow(null);
        if (res == null) {
            throw new IllegalStateException("Task execution is not complete yet, cannot get hybrid timestamp.");
        }
        assert (res.get2() != null) : "Task result timestamp should not be null";
        return (Long)res.get2();
    }

    private static class SplitResult<I, M, T, R> {
        private final MapReduceTask<I, M, T, R> task;
        private final List<MapReduceJob<M, T>> runners;

        private SplitResult(MapReduceTask<I, M, T, R> task, List<MapReduceJob<M, T>> runners) {
            this.task = task;
            this.runners = runners;
        }

        private List<MapReduceJob<M, T>> runners() {
            return this.runners;
        }

        private MapReduceTask<I, M, T, R> task() {
            return this.task;
        }
    }
}

