/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.sql.engine.exec.exp;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexNode;
import org.apache.ignite3.internal.sql.engine.exec.ExecutionContext;
import org.apache.ignite3.internal.sql.engine.exec.exp.RangeCondition;
import org.apache.ignite3.internal.sql.engine.exec.exp.RangeIterable;
import org.apache.ignite3.internal.sql.engine.exec.exp.SqlComparator;
import org.apache.ignite3.internal.sql.engine.exec.exp.SqlRowProvider;
import org.apache.ignite3.internal.sql.engine.exec.exp.SqlScalar;
import org.apache.ignite3.internal.sql.engine.prepare.bounds.ExactBounds;
import org.apache.ignite3.internal.sql.engine.prepare.bounds.MultiBounds;
import org.apache.ignite3.internal.sql.engine.prepare.bounds.RangeBounds;
import org.apache.ignite3.internal.sql.engine.prepare.bounds.SearchBounds;
import org.apache.ignite3.internal.util.CollectionUtils;
import org.jetbrains.annotations.Nullable;

class SearchBoundsImplementor {
    SearchBoundsImplementor() {
    }

    <RowT> SqlScalar<RowT, RangeIterable<RowT>> implement(List<SearchBounds> searchBounds, RelDataType indexKeyType, @Nullable SqlComparator<RowT> comparator, Function<List<RexNode>, SqlRowProvider<RowT>> rowProviderImplementor) {
        return context -> {
            ArrayList ranges = new ArrayList();
            this.expandBounds(rowProviderImplementor, context, ranges, searchBounds, 0, Arrays.asList(new RexNode[indexKeyType.getFieldCount()]), Arrays.asList(new RexNode[indexKeyType.getFieldCount()]), true, true);
            return new RangeIterableImpl(context, ranges, comparator);
        };
    }

    private static List<RexNode> shrinkBounds(List<RexNode> bound) {
        ArrayList<RexNode> newBound = new ArrayList<RexNode>();
        for (RexNode node : bound) {
            if (node == null) break;
            newBound.add(node);
        }
        return Collections.unmodifiableList(newBound);
    }

    private <RowT> void expandBounds(Function<List<RexNode>, SqlRowProvider<RowT>> rowProviderFunction, ExecutionContext<RowT> context, List<RangeCondition<RowT>> ranges, List<SearchBounds> searchBounds, int fieldIdx, List<RexNode> curLower, List<RexNode> curUpper, boolean lowerInclude, boolean upperInclude) {
        if (fieldIdx >= searchBounds.size() || !lowerInclude && !upperInclude || searchBounds.get(fieldIdx) == null) {
            curLower = SearchBoundsImplementor.shrinkBounds(curLower);
            curUpper = SearchBoundsImplementor.shrinkBounds(curUpper);
            ranges.add(new RangeConditionImpl<RowT>(context, CollectionUtils.nullOrEmpty(curLower) ? null : rowProviderFunction.apply(curLower), CollectionUtils.nullOrEmpty(curUpper) ? null : rowProviderFunction.apply(curUpper), lowerInclude, upperInclude));
            return;
        }
        SearchBounds fieldBounds = searchBounds.get(fieldIdx);
        Collection<SearchBounds> fieldMultiBounds = fieldBounds instanceof MultiBounds ? ((MultiBounds)fieldBounds).bounds() : Collections.singleton(fieldBounds);
        for (SearchBounds fieldSingleBounds : fieldMultiBounds) {
            boolean fieldLowerInclude;
            boolean fieldUpperInclude;
            RexNode fieldLowerBound;
            RexNode fieldUpperBound;
            if (fieldSingleBounds instanceof ExactBounds) {
                fieldLowerBound = fieldUpperBound = ((ExactBounds)fieldSingleBounds).bound();
                fieldUpperInclude = true;
                fieldLowerInclude = true;
            } else if (fieldSingleBounds instanceof RangeBounds) {
                RangeBounds fieldRangeBounds = (RangeBounds)fieldSingleBounds;
                fieldLowerBound = fieldRangeBounds.lowerBound();
                fieldUpperBound = fieldRangeBounds.upperBound();
                fieldLowerInclude = fieldRangeBounds.lowerInclude();
                fieldUpperInclude = fieldRangeBounds.upperInclude();
            } else {
                throw new IllegalStateException("Unexpected bounds: " + fieldSingleBounds);
            }
            if (lowerInclude) {
                curLower.set(fieldIdx, fieldLowerBound);
            }
            if (upperInclude) {
                curUpper.set(fieldIdx, fieldUpperBound);
            }
            this.expandBounds(rowProviderFunction, context, ranges, searchBounds, fieldIdx + 1, curLower, curUpper, lowerInclude && fieldLowerInclude, upperInclude && fieldUpperInclude);
        }
        curLower.set(fieldIdx, null);
        curUpper.set(fieldIdx, null);
    }

    private static class RangeConditionImpl<RowT>
    implements RangeCondition<RowT> {
        private final ExecutionContext<RowT> context;
        @Nullable
        private final SqlRowProvider<RowT> lowerBound;
        @Nullable
        private final SqlRowProvider<RowT> upperBound;
        private final boolean lowerInclude;
        private final boolean upperInclude;
        @Nullable
        private RowT lowerRow;
        @Nullable
        private RowT upperRow;

        private RangeConditionImpl(ExecutionContext<RowT> context, @Nullable SqlRowProvider<RowT> lowerScalar, @Nullable SqlRowProvider<RowT> upperScalar, boolean lowerInclude, boolean upperInclude) {
            this.context = context;
            this.lowerBound = lowerScalar;
            this.upperBound = upperScalar;
            this.lowerInclude = lowerInclude;
            this.upperInclude = upperInclude;
        }

        @Override
        @Nullable
        public RowT lower() {
            if (this.lowerBound == null) {
                return null;
            }
            return this.lowerRow != null ? this.lowerRow : (this.lowerRow = this.lowerBound.get(this.context));
        }

        @Override
        @Nullable
        public RowT upper() {
            if (this.upperBound == null) {
                return null;
            }
            return this.upperRow != null ? this.upperRow : (this.upperRow = this.upperBound.get(this.context));
        }

        @Override
        public boolean lowerInclude() {
            return this.lowerInclude;
        }

        @Override
        public boolean upperInclude() {
            return this.upperInclude;
        }

        void clearCache() {
            this.lowerRow = null;
            this.upperRow = null;
        }
    }

    private static class RangeIterableImpl<RowT>
    implements RangeIterable<RowT> {
        private final ExecutionContext<RowT> context;
        @Nullable
        private final SqlComparator<RowT> comparator;
        private List<RangeCondition<RowT>> ranges;
        private boolean sorted;

        RangeIterableImpl(ExecutionContext<RowT> context, List<RangeCondition<RowT>> ranges, @Nullable SqlComparator<RowT> comparator) {
            this.context = context;
            this.ranges = ranges;
            this.comparator = comparator;
        }

        @Override
        public boolean multiBounds() {
            return this.ranges.size() > 1;
        }

        @Override
        public Iterator<RangeCondition<RowT>> iterator() {
            this.ranges.forEach(b -> ((RangeConditionImpl)b).clearCache());
            if (this.ranges.size() == 1) {
                return this.ranges.iterator();
            }
            if (!this.sorted && this.comparator != null) {
                this.ranges.sort(this::compareRanges);
                ArrayList<RangeCondition<RowT>> ranges0 = new ArrayList<RangeCondition<RowT>>(this.ranges.size());
                RangeConditionImpl<RowT> prevRange = null;
                for (RangeCondition<RowT> range0 : this.ranges) {
                    RangeConditionImpl<RowT> range = (RangeConditionImpl<RowT>)range0;
                    if (this.compareLowerAndUpperBounds(range.lower(), range.upper()) > 0) continue;
                    if (prevRange != null) {
                        RangeConditionImpl<RowT> merged = this.tryMerge(prevRange, range);
                        if (merged == null) {
                            ranges0.add(prevRange);
                        } else {
                            range = merged;
                        }
                    }
                    prevRange = range;
                }
                if (prevRange != null) {
                    ranges0.add(prevRange);
                }
                this.ranges = ranges0;
                this.sorted = true;
            }
            return this.ranges.iterator();
        }

        private int compareRanges(RangeCondition<RowT> first, RangeCondition<RowT> second) {
            int cmp = this.compareBounds(first.lower(), second.lower(), true);
            if (cmp != 0) {
                return cmp;
            }
            return this.compareBounds(first.upper(), second.upper(), false);
        }

        private int compareBounds(@Nullable RowT row1, @Nullable RowT row2, boolean lower) {
            assert (this.comparator != null);
            if (row1 == null || row2 == null) {
                if (row1 == row2) {
                    return 0;
                }
                RowT row = lower ? row2 : row1;
                return row == null ? 1 : -1;
            }
            return this.comparator.compare(this.context, row1, row2);
        }

        private int compareLowerAndUpperBounds(@Nullable RowT lower, @Nullable RowT upper) {
            assert (this.comparator != null);
            if (lower == null || upper == null) {
                if (lower == upper) {
                    return 0;
                }
                return -1;
            }
            return this.comparator.compare(this.context, lower, upper);
        }

        @Nullable
        RangeConditionImpl<RowT> tryMerge(RangeConditionImpl<RowT> first, RangeConditionImpl<RowT> second) {
            boolean newUpperInclude;
            RowT newUpperRow;
            SqlRowProvider newUpperBound;
            boolean newLowerInclude;
            RowT newLowerRow;
            SqlRowProvider newLowerBound;
            if (this.compareLowerAndUpperBounds(first.lower(), second.upper()) > 0 || this.compareLowerAndUpperBounds(second.lower(), first.upper()) > 0) {
                return null;
            }
            int cmp = this.compareBounds(first.lower(), second.lower(), true);
            if (cmp < 0 || cmp == 0 && first.lowerInclude()) {
                newLowerBound = first.lowerBound;
                newLowerRow = first.lower();
                newLowerInclude = first.lowerInclude();
            } else {
                newLowerBound = second.lowerBound;
                newLowerRow = second.lower();
                newLowerInclude = second.lowerInclude();
            }
            cmp = this.compareBounds(first.upper(), second.upper(), false);
            if (cmp > 0 || cmp == 0 && first.upperInclude()) {
                newUpperBound = first.upperBound;
                newUpperRow = first.upper();
                newUpperInclude = first.upperInclude();
            } else {
                newUpperBound = second.upperBound;
                newUpperRow = second.upper();
                newUpperInclude = second.upperInclude();
            }
            RangeConditionImpl newRangeCondition = new RangeConditionImpl(first.context, newLowerBound, newUpperBound, newLowerInclude, newUpperInclude);
            newRangeCondition.lowerRow = newLowerRow;
            newRangeCondition.upperRow = newUpperRow;
            return newRangeCondition;
        }
    }
}

