/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.raft.jraft.storage.logit.storage.file.assit;

import org.apache.ignite3.raft.jraft.option.RaftOptions;
import org.apache.ignite3.raft.jraft.storage.logit.storage.file.assit.Checkpoint;
import org.apache.ignite3.raft.jraft.util.Bits;

public class FirstLogIndexCheckpoint
extends Checkpoint {
    public long firstLogIndex = -1L;

    public FirstLogIndexCheckpoint(String path, RaftOptions raftOptions) {
        super(path, raftOptions);
    }

    @Override
    public byte[] encode() {
        byte[] bs = new byte[8];
        Bits.putLong(bs, 0, this.firstLogIndex);
        return bs;
    }

    @Override
    public boolean decode(byte[] bs) {
        if (bs.length < 8) {
            return false;
        }
        this.firstLogIndex = Bits.getLong(bs, 0);
        return this.firstLogIndex >= 0L;
    }

    public void setFirstLogIndex(long firstLogIndex) {
        this.firstLogIndex = firstLogIndex;
    }

    public void reset() {
        this.firstLogIndex = -1L;
    }

    public boolean isInit() {
        return this.firstLogIndex >= 0L;
    }

    public String toString() {
        return "FirstLogIndexCheckpoint{firstLogIndex=" + this.firstLogIndex + "}";
    }
}

