/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.cluster.log.snapshot;

import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.Callable;
import org.apache.iotdb.cluster.client.async.AsyncDataClient;
import org.apache.iotdb.cluster.client.sync.SyncClientAdaptor;
import org.apache.iotdb.cluster.client.sync.SyncDataClient;
import org.apache.iotdb.cluster.config.ClusterDescriptor;
import org.apache.iotdb.cluster.exception.SnapshotInstallationException;
import org.apache.iotdb.cluster.log.Snapshot;
import org.apache.iotdb.cluster.log.snapshot.PullSnapshotTaskDescriptor;
import org.apache.iotdb.cluster.log.snapshot.SnapshotFactory;
import org.apache.iotdb.cluster.log.snapshot.SnapshotInstaller;
import org.apache.iotdb.cluster.partition.PartitionGroup;
import org.apache.iotdb.cluster.rpc.thrift.Node;
import org.apache.iotdb.cluster.rpc.thrift.PullSnapshotRequest;
import org.apache.iotdb.cluster.rpc.thrift.PullSnapshotResp;
import org.apache.iotdb.cluster.server.member.DataGroupMember;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PullSnapshotTask<T extends Snapshot>
implements Callable<Void> {
    public static final String TASK_SUFFIX = ".task";
    private static final Logger logger = LoggerFactory.getLogger(PullSnapshotTask.class);
    private PullSnapshotTaskDescriptor descriptor;
    private DataGroupMember newMember;
    private PullSnapshotRequest request;
    private SnapshotFactory<T> snapshotFactory;
    private File snapshotSave;
    private Random random = new Random();

    public PullSnapshotTask(PullSnapshotTaskDescriptor descriptor, DataGroupMember newMember, SnapshotFactory<T> snapshotFactory, File snapshotSave) {
        this.descriptor = descriptor;
        this.newMember = newMember;
        this.snapshotFactory = snapshotFactory;
        this.snapshotSave = snapshotSave;
        this.persistTask();
    }

    private boolean pullSnapshot(int nodeIndex) throws InterruptedException, TException {
        Map<Integer, T> result;
        Node node = (Node)this.descriptor.getPreviousHolders().get(nodeIndex);
        if (logger.isDebugEnabled()) {
            logger.debug("Pulling slot {} and other {} snapshots from {} of {} for {}", new Object[]{this.descriptor.getSlots().get(0), this.descriptor.getSlots().size() - 1, node, this.descriptor.getPreviousHolders().getHeader(), this.newMember.getName()});
        }
        if ((result = this.pullSnapshot(node)) != null) {
            ArrayList<Integer> noSnapshotSlots = new ArrayList<Integer>();
            for (Integer slot : this.descriptor.getSlots()) {
                if (result.containsKey(slot)) continue;
                this.newMember.getSlotManager().setToNull(slot, false);
                noSnapshotSlots.add(slot);
            }
            this.newMember.getSlotManager().save();
            if (!noSnapshotSlots.isEmpty() && logger.isInfoEnabled()) {
                logger.info("{}: {} and other {} slots do not have snapshot", new Object[]{this.newMember.getName(), noSnapshotSlots.get(0), noSnapshotSlots.size() - 1});
            }
            if (logger.isInfoEnabled()) {
                logger.info("{}: Received a snapshot {} from {}", new Object[]{this.newMember.getName(), result, this.descriptor.getPreviousHolders().get(nodeIndex)});
            }
            try {
                if (result.size() > 0) {
                    Snapshot snapshot = (Snapshot)result.values().iterator().next();
                    SnapshotInstaller<? extends Snapshot> installer = snapshot.getDefaultInstaller(this.newMember);
                    installer.install(result, true);
                }
                this.newMember.registerPullSnapshotHint(this.descriptor);
                return true;
            }
            catch (SnapshotInstallationException e) {
                logger.error("Apply snapshot failed, retry...", (Throwable)e);
            }
        }
        return false;
    }

    private Map<Integer, T> pullSnapshot(Node node) throws TException, InterruptedException {
        Map<Integer, T> result;
        if (ClusterDescriptor.getInstance().getConfig().isUseAsyncServer()) {
            AsyncDataClient client = (AsyncDataClient)this.newMember.getAsyncClient(node);
            if (client == null) {
                return null;
            }
            result = SyncClientAdaptor.pullSnapshot(client, this.request, this.descriptor.getSlots(), this.snapshotFactory);
        } else {
            PullSnapshotResp pullSnapshotResp;
            SyncDataClient client = (SyncDataClient)this.newMember.getSyncClient(node);
            if (client == null) {
                return null;
            }
            try {
                pullSnapshotResp = client.pullSnapshot(this.request);
            }
            catch (TException e) {
                client.close();
                throw e;
            }
            finally {
                client.returnSelf();
            }
            result = new HashMap<Integer, T>();
            for (Map.Entry integerByteBufferEntry : pullSnapshotResp.snapshotBytes.entrySet()) {
                T snapshot = this.snapshotFactory.create();
                ((Snapshot)snapshot).deserialize((ByteBuffer)integerByteBufferEntry.getValue());
                result.put((Integer)integerByteBufferEntry.getKey(), snapshot);
            }
        }
        return result;
    }

    @Override
    public Void call() {
        this.request = new PullSnapshotRequest();
        this.request.setHeader(this.descriptor.getPreviousHolders().getHeader());
        this.request.setRequiredSlots(this.descriptor.getSlots());
        this.request.setRequireReadOnly(this.descriptor.isRequireReadOnly());
        logger.info("{}: data migration starts.", (Object)this.newMember.getName());
        boolean finished = false;
        int nodeIndex = ((PartitionGroup)this.newMember.getAllNodes()).indexOf(this.newMember.getThisNode()) - 1;
        while (!finished) {
            try {
                nodeIndex = (nodeIndex + 1) % this.descriptor.getPreviousHolders().size();
                long startTime = System.currentTimeMillis();
                finished = this.pullSnapshot(nodeIndex);
                if (!finished) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("Cannot pull slot {} from {}, retry", this.descriptor.getSlots(), this.descriptor.getPreviousHolders().get(nodeIndex));
                    }
                    Thread.sleep(ClusterDescriptor.getInstance().getConfig().getPullSnapshotRetryIntervalMs());
                    continue;
                }
                if (!logger.isDebugEnabled()) continue;
                logger.debug("{}: Data migration ends, cost {}ms", (Object)this.newMember, (Object)(System.currentTimeMillis() - startTime));
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                finished = true;
            }
            catch (TException e) {
                if (!logger.isDebugEnabled()) continue;
                logger.debug("Cannot pull slot {} from {}, retry", new Object[]{this.descriptor.getSlots(), this.descriptor.getPreviousHolders().get(nodeIndex), e});
            }
        }
        this.removeTask();
        return null;
    }

    private void persistTask() {
        if (this.snapshotSave != null) {
            return;
        }
        do {
            String saveName = System.currentTimeMillis() + "_" + this.random.nextLong() + TASK_SUFFIX;
            this.snapshotSave = new File(this.newMember.getPullSnapshotTaskDir(), saveName);
        } while (this.snapshotSave.exists());
        this.snapshotSave.getParentFile().mkdirs();
        try (DataOutputStream dataOutputStream = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(this.snapshotSave)));){
            this.descriptor.serialize(dataOutputStream);
        }
        catch (IOException e) {
            logger.error("Cannot save the pulling task: pull {} from {}", new Object[]{this.descriptor.getSlots(), this.descriptor.getPreviousHolders(), e});
        }
    }

    private void removeTask() {
        try {
            Files.delete(this.snapshotSave.toPath());
        }
        catch (IOException e) {
            logger.warn("Cannot remove pull snapshot task file {}", (Object)this.snapshotSave, (Object)e);
        }
    }

    public File getSnapshotSave() {
        return this.snapshotSave;
    }
}

