/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tsfile.encoding.decoder;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.iotdb.tsfile.encoding.bitpacking.LongPacker;
import org.apache.iotdb.tsfile.encoding.decoder.RleDecoder;
import org.apache.iotdb.tsfile.exception.encoding.TsFileDecodingException;
import org.apache.iotdb.tsfile.utils.ReadWriteForEncodingUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LongRleDecoder
extends RleDecoder {
    private static final Logger logger = LoggerFactory.getLogger(LongRleDecoder.class);
    private long currentValue = 0L;
    private long[] currentBuffer;
    private LongPacker packer;

    @Override
    public long readLong(ByteBuffer buffer) {
        long result;
        if (!this.isLengthAndBitWidthReaded) {
            this.readLengthAndBitWidth(buffer);
        }
        if (this.currentCount == 0) {
            try {
                this.readNext();
            }
            catch (IOException e) {
                logger.error("tsfile-encoding IntRleDecoder: error occurs when reading all encoding number, length is {}, bit width is {}", new Object[]{this.length, this.bitWidth, e});
            }
        }
        --this.currentCount;
        switch (this.mode) {
            case RLE: {
                result = this.currentValue;
                break;
            }
            case BIT_PACKED: {
                result = this.currentBuffer[this.bitPackingNum - this.currentCount - 1];
                break;
            }
            default: {
                throw new TsFileDecodingException(String.format("tsfile-encoding LongRleDecoder: not a valid mode %s", new Object[]{this.mode}));
            }
        }
        if (!this.hasNextPackage()) {
            this.isLengthAndBitWidthReaded = false;
        }
        return result;
    }

    @Override
    protected void initPacker() {
        this.packer = new LongPacker(this.bitWidth);
    }

    @Override
    protected void readNumberInRle() throws IOException {
        this.currentValue = ReadWriteForEncodingUtils.readLongLittleEndianPaddedOnBitWidth(this.byteCache, this.bitWidth);
    }

    @Override
    protected void readBitPackingBuffer(int bitPackedGroupCount, int lastBitPackedNum) {
        this.currentBuffer = new long[bitPackedGroupCount * 8];
        byte[] bytes = new byte[bitPackedGroupCount * this.bitWidth];
        int bytesToRead = bitPackedGroupCount * this.bitWidth;
        bytesToRead = Math.min(bytesToRead, this.byteCache.remaining());
        this.byteCache.get(bytes, 0, bytesToRead);
        this.packer.unpackAllValues(bytes, bytesToRead, this.currentBuffer);
    }
}

