/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.metadata.mnode;

import java.util.ArrayList;
import java.util.Objects;
import org.apache.iotdb.db.exception.metadata.IllegalPathException;
import org.apache.iotdb.db.metadata.mnode.IEntityMNode;
import org.apache.iotdb.db.metadata.mnode.IMNode;
import org.apache.iotdb.db.metadata.mnode.IMeasurementMNode;
import org.apache.iotdb.db.metadata.mnode.IStorageGroupMNode;
import org.apache.iotdb.db.metadata.path.PartialPath;

public abstract class MNode
implements IMNode {
    protected String name;
    protected IMNode parent;
    protected String fullPath;

    public MNode(IMNode parent, String name) {
        this.parent = parent;
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public IMNode getParent() {
        return this.parent;
    }

    @Override
    public void setParent(IMNode parent) {
        this.parent = parent;
    }

    @Override
    public PartialPath getPartialPath() {
        if (this.fullPath != null) {
            try {
                return new PartialPath(this.fullPath);
            }
            catch (IllegalPathException illegalPathException) {
                // empty catch block
            }
        }
        ArrayList<String> detachedPath = new ArrayList<String>();
        IMNode temp = this;
        detachedPath.add(temp.getName());
        while (temp.getParent() != null) {
            temp = temp.getParent();
            detachedPath.add(0, temp.getName());
        }
        return new PartialPath(detachedPath.toArray(new String[0]));
    }

    @Override
    public String getFullPath() {
        if (this.fullPath == null) {
            this.fullPath = this.concatFullPath().intern();
        }
        return this.fullPath;
    }

    String concatFullPath() {
        StringBuilder builder = new StringBuilder(this.name);
        IMNode curr = this;
        while (curr.getParent() != null) {
            curr = curr.getParent();
            builder.insert(0, '.').insert(0, curr.getName());
        }
        return builder.toString();
    }

    @Override
    public void setFullPath(String fullPath) {
        this.fullPath = fullPath;
    }

    @Override
    public boolean isEmptyInternal() {
        return !"root".equals(this.name) && !this.isStorageGroup() && !this.isMeasurement() && this.getSchemaTemplate() == null && !this.isUseTemplate() && this.getChildren().size() == 0;
    }

    @Override
    public boolean isUseTemplate() {
        return false;
    }

    @Override
    public boolean isStorageGroup() {
        return false;
    }

    @Override
    public boolean isEntity() {
        return false;
    }

    @Override
    public boolean isMeasurement() {
        return false;
    }

    @Override
    public IStorageGroupMNode getAsStorageGroupMNode() {
        if (this.isStorageGroup()) {
            return (IStorageGroupMNode)((Object)this);
        }
        throw new UnsupportedOperationException("Wrong MNode Type");
    }

    @Override
    public IEntityMNode getAsEntityMNode() {
        if (this.isEntity()) {
            return (IEntityMNode)((Object)this);
        }
        throw new UnsupportedOperationException("Wrong MNode Type");
    }

    @Override
    public IMeasurementMNode getAsMeasurementMNode() {
        if (this.isMeasurement()) {
            return (IMeasurementMNode)((Object)this);
        }
        throw new UnsupportedOperationException("Wrong MNode Type");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MNode mNode = (MNode)o;
        if (this.fullPath == null) {
            return Objects.equals(this.getFullPath(), mNode.getFullPath());
        }
        return Objects.equals(this.fullPath, mNode.getFullPath());
    }

    public int hashCode() {
        if (this.fullPath == null) {
            return Objects.hash(this.getFullPath());
        }
        return Objects.hash(this.fullPath);
    }

    public String toString() {
        return this.getName();
    }
}

