/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.metrics.metricsets.predefined.logback;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.spi.LoggerContextListener;
import ch.qos.logback.classic.turbo.TurboFilter;
import java.util.HashMap;
import java.util.Map;
import org.apache.iotdb.metrics.AbstractMetricService;
import org.apache.iotdb.metrics.metricsets.IMetricSet;
import org.apache.iotdb.metrics.metricsets.predefined.logback.MetricsTurboFilter;
import org.apache.iotdb.metrics.utils.MetricType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogbackMetrics
implements IMetricSet {
    private static final Logger logger = LoggerFactory.getLogger(LogbackMetrics.class);
    static ThreadLocal<Boolean> ignoreMetrics = new ThreadLocal();
    private final LoggerContext loggerContext = (LoggerContext)LoggerFactory.getILoggerFactory();
    private final Map<AbstractMetricService, MetricsTurboFilter> metricsTurboFilters = new HashMap<AbstractMetricService, MetricsTurboFilter>();

    public LogbackMetrics() {
        this.loggerContext.addListener(new LoggerContextListener(){

            public boolean isResetResistant() {
                return true;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onReset(LoggerContext context) {
                Map map = LogbackMetrics.this.metricsTurboFilters;
                synchronized (map) {
                    for (MetricsTurboFilter addMetricsTurboFilter : LogbackMetrics.this.metricsTurboFilters.values()) {
                        LogbackMetrics.this.loggerContext.addTurboFilter((TurboFilter)addMetricsTurboFilter);
                    }
                }
            }

            public void onStart(LoggerContext context) {
            }

            public void onStop(LoggerContext context) {
            }

            public void onLevelChange(ch.qos.logback.classic.Logger logger, Level level) {
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void bindTo(AbstractMetricService metricService) {
        MetricsTurboFilter filter = new MetricsTurboFilter(metricService);
        Map<AbstractMetricService, MetricsTurboFilter> map = this.metricsTurboFilters;
        synchronized (map) {
            this.metricsTurboFilters.put(metricService, filter);
            this.loggerContext.addTurboFilter((TurboFilter)filter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unbindFrom(AbstractMetricService metricService) {
        try {
            Map<AbstractMetricService, MetricsTurboFilter> map = this.metricsTurboFilters;
            synchronized (map) {
                for (MetricsTurboFilter addMetricsTurboFilter : this.metricsTurboFilters.values()) {
                    this.loggerContext.getTurboFilterList().remove((Object)addMetricsTurboFilter);
                }
                metricService.remove(MetricType.COUNTER, "logback.events", "level", "error");
                metricService.remove(MetricType.COUNTER, "logback.events", "level", "warn");
                metricService.remove(MetricType.COUNTER, "logback.events", "level", "info");
                metricService.remove(MetricType.COUNTER, "logback.events", "level", "debug");
                metricService.remove(MetricType.COUNTER, "logback.events", "level", "trace");
            }
        }
        catch (Exception e) {
            logger.error("Failed to remove LogBackMetrics.");
        }
    }
}

