/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.udf.builtin;

import java.util.ArrayList;
import org.apache.iotdb.commons.udf.utils.MasterRepairUtil;
import org.apache.iotdb.udf.api.UDTF;
import org.apache.iotdb.udf.api.access.Row;
import org.apache.iotdb.udf.api.collector.PointCollector;
import org.apache.iotdb.udf.api.customizer.config.UDTFConfigurations;
import org.apache.iotdb.udf.api.customizer.parameter.UDFParameterValidator;
import org.apache.iotdb.udf.api.customizer.parameter.UDFParameters;
import org.apache.iotdb.udf.api.customizer.strategy.AccessStrategy;
import org.apache.iotdb.udf.api.customizer.strategy.RowByRowAccessStrategy;
import org.apache.iotdb.udf.api.type.Type;

public class UDTFMasterRepair
implements UDTF {
    private MasterRepairUtil masterRepairUtil;
    private int outputColumn;

    public void validate(UDFParameterValidator validator) throws Exception {
        for (int i = 0; i < validator.getParameters().getChildExpressionsSize(); ++i) {
            validator.validateInputSeriesDataType(i, new Type[]{Type.DOUBLE, Type.FLOAT, Type.INT32, Type.INT64});
        }
        if (validator.getParameters().hasAttribute("omega")) {
            validator.validate(omega -> (Integer)omega >= 0, "Parameter omega should be non-negative.", (Object)validator.getParameters().getInt("omega"));
        }
        if (validator.getParameters().hasAttribute("eta")) {
            validator.validate(eta -> (Double)eta > 0.0, "Parameter eta should be larger than 0.", (Object)validator.getParameters().getDouble("eta"));
        }
        if (validator.getParameters().hasAttribute("k")) {
            validator.validate(k -> (Integer)k > 0, "Parameter k should be a positive integer.", (Object)validator.getParameters().getInt("k"));
        }
        if (validator.getParameters().hasAttribute("output_column")) {
            validator.validate(outputColumn -> (Integer)outputColumn > 0, "Parameter output_column should be a positive integer.", (Object)validator.getParameters().getInt("output_column"));
        }
    }

    public void beforeStart(UDFParameters parameters, UDTFConfigurations configurations) throws Exception {
        configurations.setAccessStrategy((AccessStrategy)new RowByRowAccessStrategy());
        configurations.setOutputDataType(Type.DOUBLE);
        int columnCnt = parameters.getDataTypes().size() / 2;
        long omega = parameters.getLongOrDefault("omega", -1L);
        double eta = parameters.getDoubleOrDefault("eta", Double.NaN);
        int k = parameters.getIntOrDefault("k", -1);
        this.masterRepairUtil = new MasterRepairUtil(columnCnt, omega, eta, k);
        this.outputColumn = parameters.getIntOrDefault("output_column", 1);
    }

    public void transform(Row row, PointCollector collector) throws Exception {
        if (!this.masterRepairUtil.isNullRow(row)) {
            this.masterRepairUtil.addRow(row);
        }
    }

    public void terminate(PointCollector collector) throws Exception {
        this.masterRepairUtil.repair();
        ArrayList<Long> times = this.masterRepairUtil.getTime();
        ArrayList<Double> column = this.masterRepairUtil.getCleanResultColumn(this.outputColumn);
        for (int i = 0; i < column.size(); ++i) {
            collector.putDouble(times.get(i).longValue(), column.get(i).doubleValue());
        }
    }
}

