/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.subscription.task.subtask;

import org.apache.iotdb.commons.pipe.agent.task.connection.UnboundedBlockingPendingQueue;
import org.apache.iotdb.commons.pipe.agent.task.subtask.PipeSubtask;
import org.apache.iotdb.db.pipe.agent.task.execution.PipeSinkSubtaskExecutor;
import org.apache.iotdb.db.pipe.agent.task.subtask.sink.PipeSinkSubtask;
import org.apache.iotdb.db.pipe.agent.task.subtask.sink.PipeSinkSubtaskLifeCycle;
import org.apache.iotdb.db.subscription.agent.SubscriptionAgent;
import org.apache.iotdb.db.subscription.task.subtask.SubscriptionSinkSubtask;
import org.apache.iotdb.pipe.api.event.Event;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubscriptionSinkSubtaskLifeCycle
extends PipeSinkSubtaskLifeCycle {
    private static final Logger LOGGER = LoggerFactory.getLogger(SubscriptionSinkSubtaskLifeCycle.class);

    public SubscriptionSinkSubtaskLifeCycle(PipeSinkSubtaskExecutor executor, PipeSinkSubtask subtask, UnboundedBlockingPendingQueue<Event> pendingQueue) {
        super(executor, subtask, pendingQueue);
    }

    @Override
    public synchronized void register() {
        if (this.registeredTaskCount < 0) {
            throw new IllegalStateException("registeredTaskCount < 0");
        }
        if (this.registeredTaskCount == 0) {
            SubscriptionAgent.broker().bindPrefetchingQueue((SubscriptionSinkSubtask)this.subtask);
            this.executor.register((PipeSubtask)this.subtask);
            this.runningTaskCount = 0;
        }
        ++this.registeredTaskCount;
        LOGGER.info("Register subtask {}. runningTaskCount: {}, registeredTaskCount: {}", new Object[]{this.subtask, this.runningTaskCount, this.registeredTaskCount});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized boolean deregister(String pipeNameToDeregister, int regionId) {
        block4: {
            boolean bl;
            if (this.registeredTaskCount <= 0) {
                throw new IllegalStateException("registeredTaskCount <= 0");
            }
            try {
                if (this.registeredTaskCount <= 1) break block4;
                bl = false;
                --this.registeredTaskCount;
            }
            catch (Throwable throwable) {
                --this.registeredTaskCount;
                LOGGER.info("Deregister subtask {}. runningTaskCount: {}, registeredTaskCount: {}", new Object[]{this.subtask, this.runningTaskCount, this.registeredTaskCount});
                throw throwable;
            }
            LOGGER.info("Deregister subtask {}. runningTaskCount: {}, registeredTaskCount: {}", new Object[]{this.subtask, this.runningTaskCount, this.registeredTaskCount});
            return bl;
        }
        this.close();
        boolean bl = true;
        --this.registeredTaskCount;
        LOGGER.info("Deregister subtask {}. runningTaskCount: {}, registeredTaskCount: {}", new Object[]{this.subtask, this.runningTaskCount, this.registeredTaskCount});
        return bl;
    }

    @Override
    public synchronized void close() {
        super.close();
        String consumerGroupId = ((SubscriptionSinkSubtask)this.subtask).getConsumerGroupId();
        String topicName = ((SubscriptionSinkSubtask)this.subtask).getTopicName();
        SubscriptionAgent.broker().unbindPrefetchingQueue(consumerGroupId, topicName);
    }
}

