/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.udf.api.relational.table.argument;

import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.iotdb.udf.api.relational.table.argument.ScalarArgument;
import org.apache.iotdb.udf.api.relational.table.argument.TableArgument;

public interface Argument {
    public void serialize(ByteBuffer var1);

    public void serialize(DataOutputStream var1) throws IOException;

    public static Argument deserialize(ByteBuffer buffer) {
        ArgumentType type = ArgumentType.values()[buffer.getInt()];
        switch (type) {
            case TABLE_ARGUMENT: {
                return TableArgument.deserialize(buffer);
            }
            case SCALAR_ARGUMENT: {
                return ScalarArgument.deserialize(buffer);
            }
        }
        throw new IllegalArgumentException("Unknown argument type: " + (Object)((Object)type));
    }

    public static enum ArgumentType {
        TABLE_ARGUMENT,
        SCALAR_ARGUMENT;

    }
}

