/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.juneau.transforms;

import static org.apache.juneau.commons.utils.CollectionUtils.*;
import static org.junit.jupiter.api.Assertions.*;

import java.util.*;

import org.apache.juneau.*;
import org.apache.juneau.json.*;
import org.apache.juneau.swaps.*;
import org.junit.jupiter.api.*;

class EnumerationSwapTest extends TestBase {

	//====================================================================================================
	// test
	//====================================================================================================
	@Test void a01_test() throws Exception {
		var s = JsonSerializer.create().json5().swaps(EnumerationSwap.class).build();
		var v = new Vector<>(l(a("foo","bar","baz")));
		var e = v.elements();
		assertEquals("['foo','bar','baz']", s.serialize(e));
	}
}