/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.test.junit;

import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.test.junit.LoggerContextResolver;
import org.apache.logging.log4j.core.test.junit.Named;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;
import org.junit.jupiter.api.extension.ParameterResolver;

class AppenderResolver
implements ParameterResolver {
    AppenderResolver() {
    }

    public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        return Appender.class.isAssignableFrom(parameterContext.getParameter().getType()) && parameterContext.isAnnotated(Named.class);
    }

    public Object resolveParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        LoggerContext loggerContext = LoggerContextResolver.getParameterLoggerContext(parameterContext, extensionContext);
        if (loggerContext == null) {
            throw new ParameterResolutionException("No LoggerContext defined");
        }
        String name = parameterContext.findAnnotation(Named.class).map(Named::value).map(s -> s.isEmpty() ? parameterContext.getParameter().getName() : s).orElseThrow(() -> new ParameterResolutionException("No @Named present after checking earlier"));
        Appender appender = loggerContext.getConfiguration().getAppender(name);
        if (appender == null) {
            throw new ParameterResolutionException("No appender named " + name);
        }
        return appender;
    }
}

